/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.languages;

import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.LiteralUtilException;
import org.eclipse.rdf4j.rio.LanguageHandler;

public class RFC3066LanguageHandler
implements LanguageHandler {
    protected final Pattern matcher = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");

    public boolean isRecognizedLanguage(String languageTag) {
        if (languageTag == null) {
            throw new NullPointerException("Language tag cannot be null");
        }
        boolean result = this.matcher.matcher(languageTag).matches();
        return result;
    }

    public boolean verifyLanguage(String literalValue, String languageTag) throws LiteralUtilException {
        if (this.isRecognizedLanguage(languageTag)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return this.matcher.matcher(languageTag).matches();
        }
        throw new LiteralUtilException("Could not verify RFC3066 language tag");
    }

    public Literal normalizeLanguage(String literalValue, String languageTag, ValueFactory valueFactory) throws LiteralUtilException {
        if (this.isRecognizedLanguage(languageTag)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return valueFactory.createLiteral(literalValue, languageTag.toLowerCase().intern());
        }
        throw new LiteralUtilException("Could not normalize RFC3066 language tag");
    }

    public String getKey() {
        return "org.eclipse.rdf4j.rio.languages.RFC3066";
    }
}

