/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.sparse.KeyType;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.util.BytesUtil;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class KeyDecoder {
    private final byte[] key;
    private final int schemaBytesLength;
    private final int primaryKeyTypeOffset;
    private final int primaryKeyOffset;
    private final int primaryKeyLength;
    private final Object primaryKey;
    private final int columnNameOffset;
    private final int columnNameLength;
    private final int timestampOffset;
    private final KeyType primaryKeyType;
    private final String col;
    public final long timestamp;

    public byte[] getSchemaBytes() {
        byte[] a = new byte[this.schemaBytesLength];
        System.arraycopy(this.key, 0, a, 0, this.schemaBytesLength);
        return a;
    }

    public String getSchemaName() {
        if (!SparseRowStore.schemaNameUnicodeClean) {
            throw new UnsupportedOperationException();
        }
        return new String(this.getSchemaBytes());
    }

    public final KeyType getPrimaryKeyType() {
        return this.primaryKeyType;
    }

    public Object getPrimaryKey() {
        if (this.primaryKey == null) {
            throw new UnsupportedOperationException("Can not decode: keyType=" + (Object)((Object)this.primaryKeyType));
        }
        return this.primaryKey;
    }

    public final String getColumnName() {
        return this.col;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public KeyDecoder(byte[] key) {
        int i;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.key = key;
        int primaryKeyOffset = 0;
        boolean found = false;
        int schemaBytesLength = 0;
        for (i = 0; i < key.length; ++i) {
            if (key[i] != 0) continue;
            schemaBytesLength = i - 1;
            primaryKeyOffset = i + 1;
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("Could not locate the end of the encoded schema name: key=" + BytesUtil.toString((byte[])key));
        }
        this.schemaBytesLength = schemaBytesLength;
        this.primaryKeyTypeOffset = schemaBytesLength;
        this.primaryKeyType = KeyType.getKeyType(KeyBuilder.decodeByte(key[this.primaryKeyTypeOffset]));
        if (this.primaryKeyType.isFixedLength()) {
            this.primaryKeyLength = this.primaryKeyType.getEncodedLength();
            this.primaryKeyOffset = primaryKeyOffset;
            this.columnNameOffset = primaryKeyOffset + this.primaryKeyLength;
        } else {
            found = false;
            int primaryKeyLength = 0;
            for (i = primaryKeyOffset; i < key.length; ++i) {
                if (key[i] != 0) continue;
                primaryKeyLength = i - primaryKeyOffset;
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException("Could not locate the end of the encoded schema name: keyType=" + (Object)((Object)this.primaryKeyType) + ", key=" + BytesUtil.toString((byte[])key));
            }
            this.primaryKeyLength = primaryKeyLength;
            this.primaryKeyOffset = primaryKeyOffset;
            this.columnNameOffset = primaryKeyOffset + primaryKeyLength + 1;
        }
        switch (this.primaryKeyType) {
            case Integer: {
                this.primaryKey = KeyBuilder.decodeInt(key, primaryKeyOffset);
                break;
            }
            case Long: {
                this.primaryKey = KeyBuilder.decodeLong(key, primaryKeyOffset);
                break;
            }
            case Double: {
                this.primaryKey = KeyBuilder.decodeDouble(key, primaryKeyOffset);
                break;
            }
            case Float: {
                this.primaryKey = Float.valueOf(KeyBuilder.decodeFloat(key, primaryKeyOffset));
                break;
            }
            case Unicode: {
                if (SparseRowStore.primaryKeyUnicodeClean) {
                    byte[] bytes = new byte[this.primaryKeyLength];
                    System.arraycopy(key, primaryKeyOffset, bytes, 0, this.primaryKeyLength);
                    try {
                        this.primaryKey = new String(bytes, "UTF-8");
                        break;
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException("Could not decode the primary key: primaryKeyOffset=" + primaryKeyOffset + ", primaryKeyLength=" + this.primaryKeyLength + ", key=" + BytesUtil.toString((byte[])key));
                    }
                }
                this.primaryKey = null;
                break;
            }
            case ASCII: {
                this.primaryKey = KeyBuilder.decodeASCII(key, primaryKeyOffset, this.primaryKeyLength);
                break;
            }
            case Date: {
                this.primaryKey = new Date(KeyBuilder.decodeLong(key, primaryKeyOffset));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown keyType=" + (Object)((Object)this.primaryKeyType)));
            }
        }
        found = false;
        int columnNameLength = 0;
        int timestampOffset = 0;
        for (int i2 = this.columnNameOffset; i2 < key.length; ++i2) {
            if (key[i2] != 0) continue;
            columnNameLength = i2 - this.columnNameOffset;
            timestampOffset = i2 + 1;
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("Could not locate the end of the column name: keyType=" + (Object)((Object)this.primaryKeyType) + ", columnNameOffset=" + this.columnNameOffset + ", key=" + BytesUtil.toString((byte[])key));
        }
        this.columnNameLength = columnNameLength;
        this.timestampOffset = timestampOffset;
        byte[] bytes = new byte[columnNameLength];
        System.arraycopy(key, this.columnNameOffset, bytes, 0, columnNameLength);
        try {
            this.col = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Could not decode the column name: keyType=" + (Object)((Object)this.primaryKeyType) + ", columnNameOffset=" + this.columnNameOffset + ", columnNameLength=" + columnNameLength + ", key=" + BytesUtil.toString((byte[])key));
        }
        this.timestamp = KeyBuilder.decodeLong(key, this.timestampOffset);
    }

    public byte[] getPrefix() {
        int n = this.columnNameOffset;
        byte[] b = new byte[n];
        System.arraycopy(this.key, 0, b, 0, n);
        return b;
    }

    public int getPrefixLength() {
        return this.columnNameOffset;
    }

    public String toString() {
        return "KeyDecoder{" + (SparseRowStore.schemaNameUnicodeClean ? "schema=" + this.getSchemaName() + "," : "") + "primaryKeyType=" + (Object)((Object)this.primaryKeyType) + (SparseRowStore.primaryKeyUnicodeClean ? ",primaryKey=" + this.getPrimaryKey() : "") + ",col=" + this.col + ",timestamp=" + this.timestamp + ",key=" + BytesUtil.toString((byte[])this.key) + "}";
    }
}

