/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial.impl;

import com.bigdata.rdf.internal.gis.CoordinateDD;

public class GeoSpatialUtility {

    public static class BoundingBoxLatLonTime {
        private final PointLatLonTime centerPoint;
        private final Double distanceLat;
        private final Double distanceLon;
        private final Long distanceTime;

        public BoundingBoxLatLonTime(PointLatLonTime centerPoint, Double distanceLat, Double distanceLon, Long distanceTime) {
            this.centerPoint = centerPoint;
            this.distanceLat = distanceLat;
            this.distanceLon = distanceLon;
            this.distanceTime = distanceTime;
        }

        public PointLatLonTime getLowerBorder() {
            return new PointLatLonTime(this.centerPoint.getSpatialPoint().getLat() - this.distanceLat, this.centerPoint.getSpatialPoint().getLon() - this.distanceLon, this.centerPoint.getTimestamp() - this.distanceTime);
        }

        public PointLatLonTime getUpperBorder() {
            return new PointLatLonTime(this.centerPoint.getSpatialPoint().getLat() + this.distanceLat, this.centerPoint.getSpatialPoint().getLon() + this.distanceLon, this.centerPoint.getTimestamp() + this.distanceTime);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Center point: ");
            buf.append(this.centerPoint);
            buf.append("\n");
            buf.append("Distance (lat/lon/time): ");
            buf.append(this.distanceLat);
            buf.append("/");
            buf.append(this.distanceLon);
            buf.append("/");
            buf.append(this.distanceTime);
            buf.append("\n");
            buf.append("-> Low border: ");
            buf.append(this.getLowerBorder());
            buf.append("\n");
            buf.append("-> High border: ");
            buf.append(this.getUpperBorder());
            buf.append("\n");
            return buf.toString();
        }
    }

    public static class PointLatLonTime {
        public static final String POINT_SEPARATOR = "#";
        private final PointLatLon spatialPoint;
        private final Long timestamp;

        public PointLatLonTime(String s) throws NumberFormatException {
            if (s == null || s.isEmpty()) {
                throw new NumberFormatException("Point is null or empty.");
            }
            String[] xyCoord = s.split(POINT_SEPARATOR);
            if (xyCoord.length != 3) {
                throw new NumberFormatException("Point must have 2 components, but has " + xyCoord.length);
            }
            this.spatialPoint = new PointLatLon(Double.valueOf(xyCoord[0]), Double.valueOf(xyCoord[1]));
            this.timestamp = Long.valueOf(xyCoord[2]);
        }

        public PointLatLonTime(CoordinateDD spatialPoint, Long timestamp) {
            this(new PointLatLon(spatialPoint), timestamp);
        }

        public PointLatLonTime(PointLatLon spatialPoint, Long timestamp) {
            this.spatialPoint = spatialPoint;
            this.timestamp = timestamp;
        }

        public PointLatLonTime(Double xCoord, Double yCoord, Long timestamp) {
            this(new PointLatLon(xCoord, yCoord), timestamp);
        }

        public PointLatLon getSpatialPoint() {
            return this.spatialPoint;
        }

        public Double getLat() {
            return this.spatialPoint.getLat();
        }

        public Double getLon() {
            return this.spatialPoint.getLon();
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getLat());
            buf.append(POINT_SEPARATOR);
            buf.append(this.getLon());
            buf.append(POINT_SEPARATOR);
            buf.append(this.getTimestamp());
            return buf.toString();
        }

        public static Object[] toComponentString(PointLatLonTime point) {
            Object[] components = new Object[]{point.getSpatialPoint().getLat(), point.getSpatialPoint().getLon(), point.getTimestamp()};
            return components;
        }
    }

    public static class PointLatLon {
        public static final String POINT_SEPARATOR = "#";
        final CoordinateDD point;

        public PointLatLon(CoordinateDD point) {
            this.point = point;
        }

        public PointLatLon(String s) throws NumberFormatException {
            if (s == null || s.isEmpty()) {
                throw new NumberFormatException("Point is null or empty.");
            }
            String[] coords = s.split(POINT_SEPARATOR);
            if (coords.length != 2) {
                throw new NumberFormatException("Point must have 2 components, but has " + coords.length);
            }
            this.point = new CoordinateDD(Double.valueOf(coords[0]), Double.valueOf(coords[1]));
        }

        public PointLatLon(Double lat, Double lon) {
            this.point = new CoordinateDD(lat, lon);
        }

        public Double getLat() {
            return this.point.northSouth;
        }

        public Double getLon() {
            return this.point.eastWest;
        }

        public CoordinateDD asCoordinateDD() {
            return this.point;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getLat());
            buf.append(POINT_SEPARATOR);
            buf.append(this.getLon());
            return buf.toString();
        }

        public static Object[] toComponentString(PointLatLon point) {
            Object[] components = new Object[]{point.getLat(), point.getLon()};
            return components;
        }
    }
}

