/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial;

import com.bigdata.counters.CAT;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.Instrument;

public class GeoSpatialCounters
implements ICounterSetAccess {
    protected final CAT geoSpatialSearchRequests = new CAT();
    protected final CAT zOrderIndexScannedValues = new CAT();
    protected final CAT zOrderIndexHits = new CAT();
    protected final CAT zOrderIndexMisses = new CAT();
    protected final CAT bigMinCalculationTime = new CAT();
    protected final CAT rangeCheckCalculationTime = new CAT();
    protected final CAT filterCalculationTime = new CAT();
    protected final CAT geoSpatialServiceCallTasks = new CAT();
    protected final CAT geoSpatialServiceCallSubRangeTasks = new CAT();

    public void registerGeoSpatialSearchRequest() {
        this.geoSpatialSearchRequests.increment();
    }

    public void registerZOrderIndexHit() {
        this.zOrderIndexScannedValues.increment();
        this.zOrderIndexHits.increment();
    }

    public void registerZOrderIndexMiss() {
        this.zOrderIndexScannedValues.increment();
        this.zOrderIndexMisses.increment();
    }

    public void addBigMinCalculationTime(long timeInNanoSec) {
        this.bigMinCalculationTime.add(timeInNanoSec);
    }

    public void addRangeCheckCalculationTime(long timeInNanoSec) {
        this.rangeCheckCalculationTime.add(timeInNanoSec);
    }

    public void addFilterCalculationTime(long timeInNanoSec) {
        this.filterCalculationTime.add(timeInNanoSec);
    }

    public void registerGeoSpatialServiceCallTask() {
        this.geoSpatialServiceCallTasks.increment();
    }

    public void registerGeoSpatialServiceCallSubRangeTasks(long numSubtasks) {
        this.geoSpatialServiceCallSubRangeTasks.add(numSubtasks);
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        root.addCounter("geoSpatialSearchRequests", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(GeoSpatialCounters.this.geoSpatialSearchRequests.get());
            }
        });
        root.addCounter("geoSpatialServiceCallTasks", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(GeoSpatialCounters.this.geoSpatialServiceCallTasks.get());
            }
        });
        root.addCounter("geoSpatialServiceCallSubRangeTasks", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(GeoSpatialCounters.this.geoSpatialServiceCallSubRangeTasks.get());
            }
        });
        root.addCounter("zOrderIndexScannedValues", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(GeoSpatialCounters.this.zOrderIndexScannedValues.get());
            }
        });
        root.addCounter("zOrderIndexHits", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(GeoSpatialCounters.this.zOrderIndexHits.get());
            }
        });
        root.addCounter("zOrderIndexMisses", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(GeoSpatialCounters.this.zOrderIndexMisses.get());
            }
        });
        root.addCounter("zOrderIndexHitRatio", new Instrument<Double>(){

            @Override
            public void sample() {
                long hits = GeoSpatialCounters.this.zOrderIndexHits.get();
                long misses = GeoSpatialCounters.this.zOrderIndexMisses.get();
                if (hits > 0L || misses > 0L) {
                    this.setValue((double)hits / (double)(hits + misses));
                }
            }
        });
        root.addCounter("bigMinCalculationTimeMS", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(GeoSpatialCounters.this.bigMinCalculationTime.get() / 1000000L);
            }
        });
        root.addCounter("rangeCheckCalculationTimeMS", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(GeoSpatialCounters.this.rangeCheckCalculationTime.get() / 1000000L);
            }
        });
        root.addCounter("filterCalculationTimeMS", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(GeoSpatialCounters.this.filterCalculationTime.get() / 1000000L);
            }
        });
        return root;
    }
}

