/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.httpd.CounterSetHTTPD;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IFederationDelegate;
import com.bigdata.service.IService;
import com.bigdata.util.httpd.AbstractHTTPD;
import java.io.IOException;
import java.util.UUID;
import org.apache.log4j.Logger;

public class DefaultClientDelegate<T>
implements IFederationDelegate<T> {
    private static final Logger log = Logger.getLogger(DefaultClientDelegate.class);
    private final UUID uuid = UUID.randomUUID();
    private final IBigdataClient<?> client;
    private final T clientOrService;

    public DefaultClientDelegate(IBigdataClient<?> client, T clientOrService) {
        if (client == null) {
            throw new IllegalArgumentException();
        }
        if (clientOrService == null) {
            log.warn((Object)("Client or service not specified: " + this));
        }
        this.client = client;
        this.clientOrService = clientOrService;
    }

    @Override
    public T getService() {
        return this.clientOrService;
    }

    @Override
    public UUID getServiceUUID() {
        return this.uuid;
    }

    @Override
    public String getServiceName() {
        return this.client.getClass().getName() + "@" + AbstractStatisticsCollector.fullyQualifiedHostName + "#" + this.client.hashCode();
    }

    @Override
    public Class getServiceIface() {
        return this.client.getClass();
    }

    @Override
    public void reattachDynamicCounters() {
    }

    @Override
    public boolean isServiceReady() {
        return true;
    }

    @Override
    public void didStart() {
    }

    @Override
    public void serviceJoin(IService service, UUID serviceUUID) {
    }

    @Override
    public void serviceLeave(UUID serviceUUID) {
    }

    @Override
    public AbstractHTTPD newHttpd(int httpdPort, ICounterSetAccess access) throws IOException {
        return new CounterSetHTTPD(httpdPort, access);
    }
}

