/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.Banner;
import com.bigdata.service.AbstractService;
import com.bigdata.service.DataService;
import com.bigdata.service.DefaultServiceFederationDelegate;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IClientService;
import com.bigdata.service.IFederationCallable;
import com.bigdata.service.ISession;
import com.bigdata.service.Session;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public abstract class ClientService
extends AbstractService
implements IClientService,
ISession {
    protected static final Logger log = Logger.getLogger(DataService.class);
    private final Properties properties;
    private final Session session = new Session();
    private boolean open = true;

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isOpen()) {
            return;
        }
        this.open = false;
    }

    @Override
    public synchronized void shutdownNow() {
        if (!this.isOpen()) {
            return;
        }
        this.open = false;
    }

    public final boolean isOpen() {
        return this.open;
    }

    public ClientService(Properties properties) {
        Banner.banner();
        this.properties = (Properties)properties.clone();
    }

    @Override
    public AbstractService start() {
        return this;
    }

    @Override
    public Class<? extends IClientService> getServiceIface() {
        return IClientService.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<? extends Object> submit(Callable<? extends Object> task) {
        this.setupLoggingContext();
        try {
            if (task == null) {
                throw new IllegalArgumentException();
            }
            if (task instanceof IFederationCallable) {
                ((IFederationCallable)((Object)task)).setFederation(this.getFederation());
            }
            Future<? extends Object> future = this.getFederation().getExecutorService().submit(task);
            return future;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    public static class ClientServiceFederationDelegate
    extends DefaultServiceFederationDelegate<ClientService> {
        public ClientServiceFederationDelegate(ClientService service) {
            super(service);
        }
    }

    public static interface Options
    extends IBigdataClient.Options {
    }
}

