/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.bop.IPredicate;
import com.bigdata.bop.joinGraph.IEvaluationPlan;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.eval.IRuleState;
import com.bigdata.striterator.IKeyOrder;
import java.text.DateFormat;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;

public class RuleStats {
    private static final transient String sep = ", ";
    private boolean aggregation;
    public final String name;
    public final IStep rule;
    public int closureRound = 0;
    public AtomicLong solutionCount = new AtomicLong();
    public AtomicLong mutationCount = new AtomicLong();
    public final long startTime = System.currentTimeMillis();
    public long elapsed;
    public final int[] nvars;
    public final int[] evalOrder;
    public final int[] permutation;
    public final IKeyOrder[] keyOrder;
    public final long[] rangeCount;
    public final long[] chunkCount;
    public final long[] elementCount;
    public final int[] subqueryCount;
    private static final boolean showInEvalOrder = true;
    private String depthStr = ".........";
    private static final boolean showSingleRuleInTable = true;
    public List<RuleStats> detailStats = new Vector<RuleStats>();

    public RuleStats(IStep step) {
        this.rule = step;
        this.name = step.getName();
        if (step.isRule()) {
            int tailCount = ((IRule)step).getTailCount();
            this.evalOrder = new int[tailCount];
            this.permutation = new int[tailCount];
            this.keyOrder = new IKeyOrder[tailCount];
            this.nvars = new int[tailCount];
            this.chunkCount = new long[tailCount];
            this.subqueryCount = new int[tailCount];
            this.elementCount = new long[tailCount];
            this.rangeCount = new long[tailCount];
        } else {
            this.evalOrder = null;
            this.permutation = null;
            this.keyOrder = null;
            this.nvars = null;
            this.chunkCount = null;
            this.subqueryCount = null;
            this.elementCount = null;
            this.rangeCount = null;
        }
        this.aggregation = true;
    }

    public RuleStats(IRuleState ruleState) {
        this(ruleState.getRule());
        int i;
        IRule rule = ruleState.getRule();
        IEvaluationPlan plan = ruleState.getPlan();
        int tailCount = rule.getTailCount();
        System.arraycopy(ruleState.getNVars(), 0, this.nvars, 0, tailCount);
        System.arraycopy(plan.getOrder(), 0, this.evalOrder, 0, tailCount);
        System.arraycopy(ruleState.getKeyOrder(), 0, this.keyOrder, 0, tailCount);
        for (i = 0; i < tailCount; ++i) {
            this.permutation[this.evalOrder[i]] = i;
        }
        for (i = 0; i < tailCount; ++i) {
            this.rangeCount[i] = plan.rangeCount(i);
        }
        this.aggregation = false;
    }

    public String getHeadings() {
        return "startTime, rule, elapsed, solutionCount, solutions/sec, mutationCount, mutations/sec, evalOrder, keyOrder, nvars, rangeCount, chunkCount, elementCount, subqueryCount, tailIndex, tailPredicate";
    }

    public String toStringSimple(int depth, boolean titles, boolean joinDetails) {
        String mutationCountStr;
        String solutionCountStr;
        String ZE = "0";
        String NA = "0";
        String DZ = "0";
        long solutionCount = this.solutionCount.get();
        String string = solutionCountStr = solutionCount == 0L ? "0" : "" + solutionCount;
        String solutionsPerSec = solutionCount == 0L ? "0" : (this.elapsed == 0L ? "0" : "" + (long)((double)solutionCount * 1000.0 / (double)this.elapsed));
        long mutationCount = this.mutationCount.get();
        String string2 = mutationCountStr = mutationCount == 0L ? "0" : "" + mutationCount;
        String mutationsPerSec = mutationCount == 0L ? "0" : (this.elapsed == 0L ? "0" : "" + (long)((double)mutationCount * 1000.0 / (double)this.elapsed));
        String q = "";
        StringBuilder sb = new StringBuilder();
        String ruleNameStr = "\"" + this.depthStr.substring(0, depth) + this.name.replace(",", "") + (this.closureRound == 0 ? "" : " round#" + this.closureRound) + "\"";
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        String dateStr = dateFormat.format(this.startTime).replace(",", "");
        sb.append((titles ? "startTime=" : "") + dateStr);
        sb.append(sep + (titles ? "rule=" : "") + ruleNameStr);
        sb.append(sep + (titles ? "elapsed=" : "") + this.elapsed);
        sb.append(sep + (titles ? "solutionCount=" : "") + solutionCountStr);
        sb.append(sep + (titles ? "solutions/sec=" : "") + solutionsPerSec);
        sb.append(sep + (titles ? "mutationCount=" : "") + mutationCountStr);
        sb.append(sep + (titles ? "mutations/sec=" : "") + mutationsPerSec);
        if (!this.aggregation) {
            if (!joinDetails) {
                sb.append(sep + (titles ? "evalOrder=" : "") + "" + this.toString(this.evalOrder) + "");
                sb.append(sep + (titles ? "keyOrder=" : "") + "" + this.toString(this.keyOrder) + "");
                sb.append(sep + (titles ? "nvars=" : "") + "" + this.toString(this.nvars) + "");
                sb.append(sep + (titles ? "rangeCount=" : "") + "" + this.toString(this.rangeCount) + "");
                sb.append(sep + (titles ? "chunkCount=" : "") + "" + this.toString(this.chunkCount) + "");
                sb.append(sep + (titles ? "elementCount=" : "") + "" + this.toString(this.elementCount) + "");
                sb.append(sep + (titles ? "subqueryCount=" : "") + "" + this.toString(this.subqueryCount) + "");
            } else {
                IRule r = (IRule)this.rule;
                int tailCount = r.getTailCount();
                int tailIndex = 0;
                while (tailIndex < tailCount) {
                    if (tailIndex > 0) {
                        sb.append("\n" + dateStr + sep + ruleNameStr + ", , , , , ");
                    }
                    int i = this.evalOrder[tailIndex];
                    int orderIndex = tailIndex++;
                    sb.append(sep + orderIndex);
                    sb.append(sep + this.keyOrder[i]);
                    sb.append(sep + this.nvars[i]);
                    sb.append(sep + this.rangeCount[i]);
                    sb.append(sep + this.chunkCount[i]);
                    sb.append(sep + this.elementCount[i]);
                    sb.append(sep + this.subqueryCount[i]);
                    sb.append(sep + i);
                    sb.append(", \"" + this.toString(r.getTail(i)).replace(",", " ") + "\"");
                }
            }
        }
        return sb.toString();
    }

    protected String toString(IPredicate pred) {
        return pred.toString();
    }

    private StringBuilder toString(int[] a) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(a[i]);
        }
        sb.append("]");
        return sb;
    }

    private StringBuilder toString(Object[] a) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(a[i]);
        }
        sb.append("]");
        return sb;
    }

    private StringBuilder toString(long[] a) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(a[i]);
        }
        sb.append("]");
        return sb;
    }

    public String toString() {
        return this.toString(0L, true);
    }

    public String toString(long minElapsed, boolean joinDetails) {
        boolean depth = false;
        if (this.detailStats.isEmpty()) {
            // empty if block
        }
        StringBuilder sb = new StringBuilder();
        RuleStats[] a = this.detailStats.toArray(new RuleStats[0]);
        sb.append("\n" + this.getHeadings());
        sb.append("\n" + this.toStringSimple(0, false, joinDetails));
        this.toString(minElapsed, joinDetails, 1, sb, a);
        sb.append("\n");
        return sb.toString();
    }

    private StringBuilder toString(long minElapsed, boolean joinDetails, int depth, StringBuilder sb, RuleStats[] a) {
        for (int i = 0; i < a.length; ++i) {
            RuleStats x = a[i];
            if (x.elapsed < minElapsed) continue;
            sb.append("\n" + x.toStringSimple(depth, false, joinDetails));
            if (!x.aggregation || x.detailStats.isEmpty()) continue;
            this.toString(minElapsed, joinDetails, depth + 1, sb, x.detailStats.toArray(new RuleStats[0]));
        }
        return sb;
    }

    public synchronized void add(RuleStats o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        this.detailStats.add(o);
        if (this.elementCount != null && o.elementCount != null) {
            for (int i = 0; i < this.elementCount.length; ++i) {
                int n = i;
                this.rangeCount[n] = this.rangeCount[n] + o.rangeCount[i];
                int n2 = i;
                this.chunkCount[n2] = this.chunkCount[n2] + o.chunkCount[i];
                int n3 = i;
                this.elementCount[n3] = this.elementCount[n3] + o.elementCount[i];
                int n4 = i;
                this.subqueryCount[n4] = this.subqueryCount[n4] + o.subqueryCount[i];
            }
        }
        this.solutionCount.addAndGet(o.solutionCount.get());
        this.elapsed += o.elapsed;
    }
}

