/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.Journal;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.store.AbstractLocalTripleStore;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LocalTripleStore
extends AbstractLocalTripleStore {
    private static final Logger log = Logger.getLogger(LocalTripleStore.class);
    private final IJournal store;

    @Override
    public IJournal getIndexManager() {
        return this.store;
    }

    @Override
    public synchronized long commit() {
        long begin = System.currentTimeMillis();
        super.commit();
        IJournal indexManager = this.getIndexManager();
        if (indexManager.isGroupCommit()) {
            return 0L;
        }
        long commitTime = this.getIndexManager().commit();
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isInfoEnabled()) {
            log.info((Object)("commit: commit latency=" + elapsed + "ms"));
        }
        return commitTime;
    }

    @Override
    public synchronized void abort() {
        super.abort();
        this.getIndexManager().abort();
    }

    @Override
    public boolean isStable() {
        return this.store.isStable();
    }

    @Override
    public boolean isReadOnly() {
        return super.isReadOnly() || this.store.isReadOnly();
    }

    @Override
    public void close() {
        super.close();
        if (!this.isReadOnly()) {
            this.store.shutdown();
        }
    }

    public LocalTripleStore(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        super(indexManager, namespace, timestamp, properties);
        if (!(indexManager instanceof IJournal)) {
            throw new UnsupportedOperationException("Not an IJournal: indexManager=" + indexManager + ", namespace=" + namespace + ", timestamp=" + TimestampUtility.toString(timestamp) + ", properties=" + properties);
        }
        this.store = (IJournal)indexManager;
    }

    static LocalTripleStore getInstance(Properties properties) {
        String namespace = "kb";
        Journal journal = new Journal(properties);
        try {
            LocalTripleStore lts = (LocalTripleStore)journal.getResourceLocator().locate("kb", 0L);
            if (lts != null) {
                return lts;
            }
            lts = new LocalTripleStore(journal, "kb", 0L, properties);
            lts.create();
            lts = (LocalTripleStore)journal.getResourceLocator().locate("kb", 0L);
            if (lts == null) {
                throw new RuntimeException("Concurrent create/destroy: kb");
            }
            return lts;
        }
        catch (Throwable ex) {
            journal.shutdownNow();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isConcurrent() {
        return this.getTimestamp() == 0L;
    }

    public static interface Options
    extends AbstractTripleStore.Options {
    }
}

