/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.GroupNodeVarBindingInfoMap;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.optimizers.ASTJoinGroupPartition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ASTJoinGroupPartitions {
    List<ASTJoinGroupPartition> partitions = new ArrayList<ASTJoinGroupPartition>();

    public ASTJoinGroupPartitions(List<IGroupMemberNode> nodes, GroupNodeVarBindingInfoMap bindingInfo, Set<IVariable<?>> externallyKnownProduced) {
        HashSet tmpKnownProduced = new HashSet(externallyKnownProduced);
        ArrayList<IGroupMemberNode> tmpNonOptionalOrMinusNodes = new ArrayList<IGroupMemberNode>();
        IGroupMemberNode tmpOptionalOrMinus = null;
        for (int i = 0; i < nodes.size(); ++i) {
            IGroupMemberNode node = nodes.get(i);
            Boolean isOptionalOrMinus = StaticAnalysis.isMinusOrOptional(node);
            if (!isOptionalOrMinus.booleanValue()) {
                tmpNonOptionalOrMinusNodes.add(node);
            } else {
                tmpOptionalOrMinus = node;
            }
            if (tmpOptionalOrMinus == null && i + 1 != nodes.size()) continue;
            ASTJoinGroupPartition partition = new ASTJoinGroupPartition(new LinkedList<IGroupMemberNode>(tmpNonOptionalOrMinusNodes), tmpOptionalOrMinus, bindingInfo, new HashSet(tmpKnownProduced));
            this.partitions.add(partition);
            tmpKnownProduced.addAll(partition.definitelyProduced);
            tmpNonOptionalOrMinusNodes.clear();
            tmpOptionalOrMinus = null;
        }
        if (this.partitions.isEmpty()) {
            ASTJoinGroupPartition partition = new ASTJoinGroupPartition(new LinkedList<IGroupMemberNode>(tmpNonOptionalOrMinusNodes), null, bindingInfo, new HashSet(tmpKnownProduced));
            this.partitions.add(partition);
        }
    }

    public List<ASTJoinGroupPartition> getPartitionList() {
        return this.partitions;
    }

    public LinkedList<IGroupMemberNode> extractNodeList(boolean includeOptionalOrMinusNode) {
        LinkedList<IGroupMemberNode> res = new LinkedList<IGroupMemberNode>();
        for (int i = 0; i < this.partitions.size(); ++i) {
            res.addAll(this.partitions.get(i).extractNodeList(includeOptionalOrMinusNode));
        }
        return res;
    }

    public void placeAtFirstPossiblePosition(IGroupMemberNode node) {
        HashSet knownBoundFromPrevPartitions = new HashSet();
        for (int i = 0; i < this.partitions.size(); ++i) {
            ASTJoinGroupPartition partition = this.partitions.get(i);
            Integer position = partition.getFirstPossiblePosition(node, knownBoundFromPrevPartitions, i < this.partitions.size() - 1);
            if (position != null) {
                partition.placeAtPosition(node, position);
                return;
            }
            if (i + 1 == this.partitions.size()) {
                if (partition.optionalOrMinus == null) {
                    partition.placeAtPosition(node, null);
                } else {
                    LinkedList<IGroupMemberNode> listWithNode = new LinkedList<IGroupMemberNode>();
                    listWithNode.add(node);
                    ASTJoinGroupPartition dummyPartition = new ASTJoinGroupPartition(listWithNode, null, partition.bindingInfoMap, partition.externallyBound);
                    this.partitions.add(dummyPartition);
                }
                return;
            }
            knownBoundFromPrevPartitions.addAll(partition.getDefinitelyProduced());
        }
    }
}

