/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.optimizers.ASTJoinGroupFilterExistsInfo;
import com.bigdata.rdf.sparql.ast.optimizers.ASTJoinGroupPartitions;
import com.bigdata.rdf.sparql.ast.optimizers.ASTTypeBasedNodeClassifier;
import com.bigdata.rdf.sparql.ast.optimizers.ASTTypeBasedNodeClassifierConstraint;
import java.util.List;

class ASTFilterPlacer {
    final ASTJoinGroupFilterExistsInfo fExInfo;
    final ASTTypeBasedNodeClassifier filterNodeClassifier;

    public ASTFilterPlacer(Iterable<IGroupMemberNode> nodeList, final ASTJoinGroupFilterExistsInfo fExInfo) {
        this.fExInfo = fExInfo;
        this.filterNodeClassifier = new ASTTypeBasedNodeClassifier(new Class[]{FilterNode.class, SubqueryRoot.class});
        this.filterNodeClassifier.addConstraintForType(SubqueryRoot.class, new ASTTypeBasedNodeClassifierConstraint(){

            @Override
            boolean appliesTo(IGroupMemberNode node) {
                if (node instanceof SubqueryRoot) {
                    return fExInfo.containsSubqueryRoot((SubqueryRoot)node);
                }
                return false;
            }
        });
        this.filterNodeClassifier.registerNodes(nodeList);
    }

    public List<IGroupMemberNode> getNonFilterNodes() {
        return this.filterNodeClassifier.getUnclassifiedNodes();
    }

    public void placeFiltersInPartitions(ASTJoinGroupPartitions partitions) {
        List<FilterNode> filterNodes = this.filterNodeClassifier.get(FilterNode.class);
        List<SubqueryRoot> askSubqueries = this.filterNodeClassifier.get(SubqueryRoot.class);
        for (IGroupMemberNode iGroupMemberNode : askSubqueries) {
            partitions.placeAtFirstPossiblePosition(iGroupMemberNode);
        }
        for (IGroupMemberNode iGroupMemberNode : filterNodes) {
            if (this.fExInfo.containsFilter((FilterNode)iGroupMemberNode)) continue;
            partitions.placeAtFirstPossiblePosition(iGroupMemberNode);
        }
        for (IGroupMemberNode iGroupMemberNode : askSubqueries) {
            partitions.placeAtFirstPossiblePosition(this.fExInfo.filterMap.get(iGroupMemberNode));
        }
    }
}

