/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupMemberValueExpressionNodeBase;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNodeContainer;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.explainhints.BottomUpSemanticsExplainHint;
import com.bigdata.rdf.sparql.ast.explainhints.UnsatisfiableMinusExplainHint;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Striterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ASTBottomUpOptimizer
implements IASTOptimizer {
    static String NAMED_SET_PREFIX = "%-bottom-up-";

    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        if (!(queryNode instanceof QueryRoot)) {
            return new QueryNodeWithBindingSet(queryNode, bindingSets);
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        LinkedList<JoinGroupNode> innerOptionalGroups = new LinkedList<JoinGroupNode>();
        if (queryRoot.getNamedSubqueries() != null) {
            for (NamedSubqueryRoot namedSubquery : queryRoot.getNamedSubqueries()) {
                GraphPatternGroup group = namedSubquery.getWhereClause();
                this.checkForBadlyDesignedLeftJoin(context, sa, group, innerOptionalGroups);
            }
        }
        GraphPatternGroup group = queryRoot.getWhereClause();
        this.checkForBadlyDesignedLeftJoin(context, sa, group, innerOptionalGroups);
        for (JoinGroupNode group2 : innerOptionalGroups) {
            this.liftBadlyDesignedLeftJoin(context, sa, queryRoot, group2);
        }
        sa = new StaticAnalysis(queryRoot, context);
        if (queryRoot.getNamedSubqueries() != null) {
            for (NamedSubqueryRoot namedSubquery : queryRoot.getNamedSubqueries()) {
                this.handleFiltersWithVariablesNotInScope(context, sa, namedSubquery, bindingSets);
            }
        }
        this.handleFiltersWithVariablesNotInScope(context, sa, queryRoot, bindingSets);
        sa = new StaticAnalysis(queryRoot, context);
        if (queryRoot.getNamedSubqueries() != null) {
            for (NamedSubqueryRoot namedSubquery : queryRoot.getNamedSubqueries()) {
                this.handleMinusWithoutSharedVariables(context, sa, namedSubquery.getWhereClause());
            }
        }
        this.handleMinusWithoutSharedVariables(context, sa, queryRoot.getWhereClause());
        return new QueryNodeWithBindingSet(queryNode, bindingSets);
    }

    private void checkForBadlyDesignedLeftJoin(IEvaluationContext context, StaticAnalysis sa, GraphPatternGroup<IGroupMemberNode> whereClause, List<JoinGroupNode> badlyDesignedLeftJoins) {
        Iterator<JoinGroupNode> itr = BOpUtility.visitAll(whereClause, JoinGroupNode.class);
        while (itr.hasNext()) {
            JoinGroupNode group = itr.next();
            if (!group.isOptional()) continue;
            this.checkForBadlyDesignedLeftJoin2(context, sa, group, badlyDesignedLeftJoins);
        }
    }

    private void checkForBadlyDesignedLeftJoin2(IEvaluationContext context, StaticAnalysis sa, GraphPatternGroup<IGroupMemberNode> group, List<JoinGroupNode> badlyDesignedLeftJoins) {
        assert (group.isOptional());
        JoinGroupNode p = group.getParentJoinGroup();
        if (p == null) {
            return;
        }
        JoinGroupNode pp = p.getParentJoinGroup();
        if (pp == null) {
            return;
        }
        Set<IVariable<?>> topDownVars = sa.getDefinitelyIncomingBindings(p, new LinkedHashSet());
        Set<IVariable<IVariable<?>>> innerGroupVars = sa.getDefinitelyProducedBindingsAndFilterVariables(group, new LinkedHashSet());
        Set<IVariable<?>> parentVars = sa.getDefinitelyProducedBindings((IBindingProducerNode)p, new LinkedHashSet(), false);
        innerGroupVars.removeAll(context.getSolutionSetStats().getAlwaysBound());
        innerGroupVars.removeAll(parentVars);
        innerGroupVars.retainAll(topDownVars);
        if (!innerGroupVars.isEmpty()) {
            badlyDesignedLeftJoins.add((JoinGroupNode)group);
        }
    }

    private void liftBadlyDesignedLeftJoin(AST2BOpContext context, StaticAnalysis sa, QueryRoot queryRoot, JoinGroupNode group) {
        JoinGroupNode tmp;
        JoinGroupNode p = group.getParentJoinGroup();
        if (p == null) {
            throw new AssertionError();
        }
        JoinGroupNode pp = p.getParentJoinGroup();
        if (pp == null) {
            return;
        }
        String namedSet = context.createVar(NAMED_SET_PREFIX);
        NamedSubqueryRoot nsr = new NamedSubqueryRoot(QueryType.SELECT, namedSet);
        nsr.setQueryHints(p.getQueryHints());
        ProjectionNode projection = new ProjectionNode();
        nsr.setProjection(projection);
        LinkedHashSet vars = new LinkedHashSet();
        sa.getMaybeProducedBindings((IBindingProducerNode)p, vars, true);
        for (IVariable iVariable : vars) {
            projection.addProjectionVar(new VarNode(iVariable.getName()));
        }
        nsr.setWhereClause(BOpUtility.deepCopy(p));
        queryRoot.getNamedSubqueriesNotNull().add(nsr);
        NamedSubqueryInclude nsi = new NamedSubqueryInclude(namedSet);
        nsi.setQueryHints(p.getQueryHints());
        if (p.isOptional()) {
            tmp = new JoinGroupNode();
            tmp.setOptional(true);
            tmp.addChild(nsi);
            pp.replaceWith(p, tmp);
        } else if (p.isMinus()) {
            tmp = new JoinGroupNode();
            tmp.setMinus(true);
            tmp.addChild(nsi);
            pp.replaceWith(p, tmp);
        } else {
            IGroupNode<IGroupMemberNode> ppNode = p.getParent();
            if (ppNode instanceof GroupNodeBase) {
                GroupNodeBase gnb = (GroupNodeBase)ppNode;
                if (ppNode instanceof JoinGroupNode) {
                    gnb.replaceWith(p, nsi);
                } else {
                    JoinGroupNode joinGroupNode = new JoinGroupNode();
                    joinGroupNode.addChild(nsi);
                    gnb.replaceWith(p, joinGroupNode);
                }
            }
        }
    }

    private void handleFiltersWithVariablesNotInScope(AST2BOpContext context, StaticAnalysis sa, QueryBase queryBase, IBindingSet[] bindingSets) {
        Set<Object> globallyScopedVars = context == null ? Collections.emptySet() : context.getGloballyScopedVariables();
        LinkedHashMap map = new LinkedHashMap();
        Iterator<JoinGroupNode> itr = BOpUtility.visitAll(queryBase.getWhereClause(), JoinGroupNode.class);
        while (itr.hasNext()) {
            JoinGroupNode p;
            JoinGroupNode group = itr.next();
            if (sa.findParent(group) instanceof FilterNode || sa.findParent(group) instanceof ArbitraryLengthPathNode) continue;
            Set<IVariable<?>> maybeBound = sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), true);
            maybeBound.addAll(globallyScopedVars);
            if (group.isOptional() && (p = group.getParentJoinGroup()) != null) {
                Set<IVariable<?>> incomingBound = sa.getMaybeProducedBindings((IBindingProducerNode)p, new LinkedHashSet(), false);
                maybeBound.addAll(incomingBound);
            }
            for (IGroupMemberNode child : group) {
                GroupMemberValueExpressionNodeBase filter;
                IValueExpressionNode nodeParent;
                if (!(child instanceof FilterNode) && !(child instanceof AssignmentNode) || !this.rewriteUnboundVariablesInFilter(context, maybeBound, map, nodeParent = (filter = (GroupMemberValueExpressionNodeBase)child) instanceof IValueExpressionNode ? (IValueExpressionNode)((Object)filter) : null, filter.getValueExpressionNode())) continue;
                ArrayList<FunctionNode> subexpr = new ArrayList<FunctionNode>();
                Iterator<FunctionNode> veitr = BOpUtility.visitAll(filter, FunctionNode.class);
                while (veitr.hasNext()) {
                    subexpr.add(veitr.next());
                }
                for (FunctionNode ive : subexpr) {
                    ive.setValueExpression(null);
                }
                GlobalAnnotations globals = new GlobalAnnotations(context.getLexiconNamespace(), context.getTimestamp());
                IStriterator it = new Striterator(BOpUtility.preOrderIteratorWithAnnotations(filter)).addFilter((IFilter)new Filter(){
                    private static final long serialVersionUID = 1L;

                    public boolean isValid(Object obj) {
                        return obj instanceof IValueExpressionNodeContainer;
                    }
                });
                while (it.hasNext()) {
                    AST2BOpUtility.toVE(context.getBOpContext(), globals, ((IValueExpressionNodeContainer)it.next()).getValueExpressionNode());
                }
            }
        }
    }

    private boolean rewriteUnboundVariablesInFilter(AST2BOpContext context, Set<IVariable<?>> maybeBound, Map<IVariable<?>, IVariable<?>> map, IValueExpressionNode parent, IValueExpressionNode node) {
        boolean modified = false;
        int arity = ((BOp)node).arity();
        for (int i = 0; i < arity; ++i) {
            BOp tmp = ((BOp)node).get(i);
            if (!(tmp instanceof IValueExpressionNode)) continue;
            IValueExpressionNode child = (IValueExpressionNode)tmp;
            modified |= this.rewriteUnboundVariablesInFilter(context, maybeBound, map, node, child);
        }
        if (!(node instanceof VarNode)) {
            return modified;
        }
        VarNode varNode = (VarNode)node;
        IVariable<IV> ovar = varNode.getValueExpression();
        if (maybeBound.contains(ovar)) {
            return modified;
        }
        Var nvar = map.get(ovar);
        if (nvar == null) {
            nvar = Var.var(context.createVar("-unbound-var-" + ovar.getName() + "-"));
            map.put(ovar, nvar);
            BottomUpSemanticsExplainHint explainHint = new BottomUpSemanticsExplainHint(ovar, nvar, (BOp)node);
            if (parent != null) {
                ((ASTBase)((Object)parent)).addExplainHint(explainHint);
            }
        }
        if (parent != null) {
            ((ASTBase)((Object)parent)).replaceAllWith((BOp)ovar, nvar);
        }
        return true;
    }

    private void handleMinusWithoutSharedVariables(IEvaluationContext context, StaticAnalysis sa, GraphPatternGroup<?> group) {
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            IGroupMemberNode child = (IGroupMemberNode)group.get(i);
            if (!(child instanceof GraphPatternGroup)) continue;
            GraphPatternGroup childGroup = (GraphPatternGroup)child;
            this.handleMinusWithoutSharedVariables(context, sa, childGroup);
            if (!childGroup.isMinus()) continue;
            Set<IVariable<?>> incomingBound = sa.getMaybeIncomingBindings(childGroup, new LinkedHashSet());
            Set<IVariable<?>> maybeProduced = sa.getMaybeProducedBindings(childGroup, new LinkedHashSet(), true);
            LinkedHashSet intersection = new LinkedHashSet(incomingBound);
            intersection.retainAll(maybeProduced);
            if (!intersection.isEmpty()) continue;
            UnsatisfiableMinusExplainHint explainHint = new UnsatisfiableMinusExplainHint(childGroup);
            group.addExplainHint(explainHint);
            group.removeChild(childGroup);
            --arity;
        }
    }
}

