/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.lbs.policy;

import com.bigdata.rdf.sail.webapp.lbs.AbstractLBSPolicy;
import com.bigdata.rdf.sail.webapp.lbs.ServiceScore;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;

public class RoundRobinLBSPolicy
extends AbstractLBSPolicy {
    private static final long serialVersionUID = 1L;
    private final AtomicLong nextService = new AtomicLong(0L);

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(",nextService=" + this.nextService.get());
    }

    @Override
    public String getReaderURI(HttpServletRequest request) {
        ServiceScore[] serviceScores = (ServiceScore[])this.serviceTableRef.get();
        if (serviceScores == null) {
            return null;
        }
        long startIndex = this.nextService.longValue();
        ServiceScore serviceScore = null;
        for (int i = 0; i < serviceScores.length; ++i) {
            int hostIndex = (int)Math.abs(((long)i + startIndex) % (long)serviceScores.length);
            serviceScore = serviceScores[hostIndex];
            if (serviceScore != null && serviceScore.getHostname() != null && serviceScore.getRequestURI() != null) continue;
        }
        this.nextService.incrementAndGet();
        if (serviceScore == null) {
            return null;
        }
        serviceScore.nrequests.increment();
        return serviceScore.getRequestURI();
    }
}

