/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.sail.sparql.ASTVisitorBase;
import com.bigdata.rdf.sail.sparql.ast.ASTDeleteData;
import com.bigdata.rdf.sail.sparql.ast.ASTIRI;
import com.bigdata.rdf.sail.sparql.ast.ASTInsertData;
import com.bigdata.rdf.sail.sparql.ast.ASTOperationContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTPrefixDecl;
import com.bigdata.rdf.sail.sparql.ast.ASTQName;
import com.bigdata.rdf.sail.sparql.ast.ASTServiceGraphPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTUnparsedQuadDataBlock;
import com.bigdata.rdf.sail.sparql.ast.Node;
import com.bigdata.rdf.sail.sparql.ast.SyntaxTreeBuilderVisitor;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.openrdf.query.MalformedQueryException;

public class PrefixDeclProcessor {
    private static final Logger log = Logger.getLogger(PrefixDeclProcessor.class);
    public static final Map<String, String> defaultDecls = new LinkedHashMap<String, String>();

    public static Map<String, String> process(ASTOperationContainer qc) throws MalformedQueryException {
        List prefixDeclList = qc.getPrefixDeclList();
        LinkedHashMap<String, String> prefixMap = new LinkedHashMap<String, String>();
        for (ASTPrefixDecl aSTPrefixDecl : prefixDeclList) {
            String prefix = aSTPrefixDecl.getPrefix();
            String iri = aSTPrefixDecl.getIRI().getValue();
            if (prefixMap.containsKey(prefix)) {
                throw new MalformedQueryException("Multiple prefix declarations for prefix '" + prefix + "'");
            }
            prefixMap.put(prefix, iri);
        }
        for (Map.Entry entry : defaultDecls.entrySet()) {
            PrefixDeclProcessor.insertDefaultPrefix(prefixMap, (String)entry.getKey(), (String)entry.getValue());
        }
        ASTUnparsedQuadDataBlock dataBlock = null;
        if (qc.getOperation() instanceof ASTInsertData) {
            ASTInsertData aSTInsertData = (ASTInsertData)qc.getOperation();
            dataBlock = (ASTUnparsedQuadDataBlock)aSTInsertData.jjtGetChild(ASTUnparsedQuadDataBlock.class);
        } else if (qc.getOperation() instanceof ASTDeleteData) {
            ASTDeleteData aSTDeleteData = (ASTDeleteData)qc.getOperation();
            dataBlock = (ASTUnparsedQuadDataBlock)aSTDeleteData.jjtGetChild(ASTUnparsedQuadDataBlock.class);
        }
        if (dataBlock != null) {
            String string = PrefixDeclProcessor.createPrefixesInSPARQLFormat(prefixMap);
            dataBlock.setDataBlock(string + dataBlock.getDataBlock());
        } else {
            QNameProcessor qNameProcessor = new QNameProcessor(prefixMap);
            try {
                qc.jjtAccept((SyntaxTreeBuilderVisitor)qNameProcessor, null);
            }
            catch (VisitorException e) {
                throw new MalformedQueryException((Throwable)e);
            }
        }
        return prefixMap;
    }

    private static void insertDefaultPrefix(Map<String, String> prefixMap, String prefix, String namespace) {
        if (!prefixMap.containsKey(prefix) && !prefixMap.containsValue(namespace)) {
            prefixMap.put(prefix, namespace);
        }
    }

    private static String createPrefixesInSPARQLFormat(Map<String, String> prefixMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : prefixMap.entrySet()) {
            sb.append("PREFIX");
            String prefix = entry.getKey();
            if (prefix != null) {
                sb.append(" " + prefix);
            }
            sb.append(":");
            sb.append(" <" + entry.getValue() + ">");
        }
        return sb.toString();
    }

    public static void processAdditionalDecls() {
        String declsFile = System.getProperty(Options.ADDITIONAL_DECLS_FILE);
        if (declsFile != null && !declsFile.equals("")) {
            File f = new File(declsFile);
            if (!f.exists()) {
                log.warn((Object)(declsFile + " passed by -D" + Options.ADDITIONAL_DECLS_FILE + " does not exist.  Ignoring.  Additional Decls will not be set."));
                return;
            }
            if (!f.canRead()) {
                log.warn((Object)(declsFile + " passed by -D" + Options.ADDITIONAL_DECLS_FILE + " is not readable.  Ignoring.  Additional Decls will not be set."));
                return;
            }
            try {
                FileReader r = new FileReader(f);
                int ch = r.read();
                StringBuffer sb = new StringBuffer();
                boolean done = false;
                while (!done) {
                    if ((char)ch == '\n' || ch == -1) {
                        done = ch == -1;
                        String s = sb.toString();
                        if (sb.length() == 0) break;
                        sb.delete(0, sb.length());
                        String[] decls = s.split(" ");
                        if (decls.length != 3) {
                            log.warn((Object)(declsFile + " line:  " + s + " is not valid.  Ignoring."));
                            log.warn((Object)"Expecting lines formatted as: \"PREFIX wdref: <http://www.wikidata.org/reference/>\"");
                            ch = r.read();
                            continue;
                        }
                        if (!decls[1].endsWith(":")) {
                            log.warn((Object)(declsFile + " line:  " + s + " is not valid. Ignoring."));
                            log.warn((Object)(decls[1] + " does not end with :"));
                            ch = r.read();
                            continue;
                        }
                        String prefix = decls[1].substring(0, decls[1].length() - 1);
                        if (!decls[2].endsWith(">") && !decls[2].startsWith("<")) {
                            log.warn((Object)(declsFile + " line:  " + s + " is not valid.  Ignoring."));
                            log.warn((Object)(decls[2] + " does not start and end with < and >, respectively."));
                            ch = r.read();
                            continue;
                        }
                        String uri = decls[2].substring(1, decls[2].length() - 1);
                        log.warn((Object)("Configured prefix: PREFIX " + prefix + ": " + uri));
                        defaultDecls.put(prefix, uri);
                    } else {
                        sb.append((char)ch);
                    }
                    ch = r.read();
                }
                r.close();
            }
            catch (IOException e) {
                log.warn((Object)(e.toString() + "\n while processing " + declsFile + " passed by -D" + Options.ADDITIONAL_DECLS_FILE + "does not exist.  Ignoring.  Additional Decls will not be set."));
            }
        }
    }

    static {
        defaultDecls.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        defaultDecls.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        defaultDecls.put("sesame", "http://www.openrdf.org/schema/sesame#");
        defaultDecls.put("owl", "http://www.w3.org/2002/07/owl#");
        defaultDecls.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        defaultDecls.put("fn", "http://www.w3.org/2005/xpath-functions#");
        defaultDecls.put("foaf", "http://xmlns.com/foaf/0.1/");
        defaultDecls.put("dc", "http://purl.org/dc/elements/1.1/");
        defaultDecls.put("hint", "http://www.bigdata.com/queryHints#");
        defaultDecls.put("bd", "http://www.bigdata.com/rdf#");
        defaultDecls.put("bds", "http://www.bigdata.com/rdf/search#");
        PrefixDeclProcessor.processAdditionalDecls();
    }

    private static class QNameProcessor
    extends ASTVisitorBase {
        private Map<String, String> prefixMap;

        public QNameProcessor(Map<String, String> prefixMap) {
            this.prefixMap = prefixMap;
        }

        @Override
        public Object visit(ASTQName qnameNode, Object data) throws VisitorException {
            String qname = qnameNode.getValue();
            int colonIdx = qname.indexOf(58);
            assert (colonIdx >= 0) : "colonIdx should be >= 0: " + colonIdx;
            String prefix = qname.substring(0, colonIdx);
            String localName = qname.substring(colonIdx + 1);
            String namespace = this.prefixMap.get(prefix);
            if (namespace == null) {
                throw new VisitorException("QName '" + qname + "' uses an undefined prefix");
            }
            localName = this.processEscapesAndHex(localName);
            ASTIRI iriNode = new ASTIRI(46);
            iriNode.setValue(namespace + localName);
            qnameNode.jjtReplaceWith((Node)iriNode);
            return null;
        }

        private String processEscapesAndHex(String localName) {
            StringBuffer unencoded = new StringBuffer();
            Pattern hexPattern = Pattern.compile("([^\\\\]|^)(%[A-F\\d][A-F\\d])", 2);
            Matcher m = hexPattern.matcher(localName);
            boolean result = m.find();
            while (result) {
                String previousChar = m.group(1);
                String encoded = m.group(2);
                int codePoint = Integer.parseInt(encoded.substring(1), 16);
                String decoded = String.valueOf(Character.toChars(codePoint));
                m.appendReplacement(unencoded, previousChar + decoded);
                result = m.find();
            }
            m.appendTail(unencoded);
            StringBuffer unescaped = new StringBuffer();
            Pattern escapedCharPattern = Pattern.compile("\\\\[_~\\.\\-!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\/\\?#\\@\\%]");
            m = escapedCharPattern.matcher(unencoded.toString());
            result = m.find();
            while (result) {
                String escaped = m.group();
                m.appendReplacement(unescaped, escaped.substring(1));
                result = m.find();
            }
            m.appendTail(unescaped);
            return unescaped.toString();
        }

        @Override
        public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
            node.setPrefixDeclarations(this.prefixMap);
            return super.visit(node, data);
        }

        private String checkForWellKnownNamespacePrefix(String prefix) {
            String namespace;
            if (prefix.equals("bd")) {
                namespace = "http://www.bigdata.com/rdf#";
                this.prefixMap.put("bd", "http://www.bigdata.com/rdf#");
            } else if (prefix.equals("bds")) {
                namespace = "http://www.bigdata.com/rdf/search#";
                this.prefixMap.put("bds", "http://www.bigdata.com/rdf/search#");
            } else if (prefix.equals("hint")) {
                namespace = "http://www.bigdata.com/queryHints#";
                this.prefixMap.put("hint", "http://www.bigdata.com/queryHints#");
            } else if (prefix.equals("rdf")) {
                namespace = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
                this.prefixMap.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            } else if (prefix.equals("rdfs")) {
                namespace = "http://www.w3.org/2000/01/rdf-schema#";
                this.prefixMap.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            } else if (prefix.equals("xsd")) {
                namespace = "http://www.w3.org/2001/XMLSchema#";
                this.prefixMap.put("xsd", "http://www.w3.org/2001/XMLSchema#");
            } else if (prefix.equals("foaf")) {
                namespace = "http://xmlns.com/foaf/0.1/";
                this.prefixMap.put("foaf", "http://xmlns.com/foaf/0.1/");
            } else if (prefix.equals("fn")) {
                namespace = "http://www.w3.org/2005/xpath-functions#";
                this.prefixMap.put("fn", "http://www.w3.org/2005/xpath-functions#");
            } else if (prefix.equals("owl")) {
                namespace = "http://www.w3.org/2002/07/owl#";
                this.prefixMap.put("owl", "http://www.w3.org/2002/07/owl#");
            } else if (prefix.equals("sesame")) {
                namespace = "http://www.openrdf.org/schema/sesame#";
                this.prefixMap.put("sesame", "http://www.openrdf.org/schema/sesame#");
            } else if (prefix.equals("gas")) {
                namespace = "http://www.bigdata.com/rdf/gas#";
                this.prefixMap.put("gas", "http://www.bigdata.com/rdf/gas#");
            } else {
                namespace = null;
            }
            return namespace;
        }
    }

    public static interface Options {
        public static final String ADDITIONAL_DECLS_FILE = PrefixDeclProcessor.class.getName() + ".additionalDeclsFile";
    }
}

