/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.load;

import com.bigdata.rdf.load.AbstractRDFTaskFactory;
import com.bigdata.rdf.load.VerifyStatementBufferFactory;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.store.AbstractTripleStore;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;

public class RDFVerifyTaskFactory<S extends Statement, T extends Runnable>
extends AbstractRDFTaskFactory<S, T> {
    public RDFVerifyTaskFactory(AbstractTripleStore db, int bufferCapacity, RDFParserOptions parserOptions, boolean deleteAfter, RDFFormat fallback) {
        super(db, parserOptions, deleteAfter, fallback, new VerifyStatementBufferFactory(db, bufferCapacity));
    }

    public long getTermCount() {
        return ((VerifyStatementBufferFactory)this.bufferFactory).nterms.get();
    }

    public long getTermNotFoundCount() {
        return ((VerifyStatementBufferFactory)this.bufferFactory).ntermsNotFound.get();
    }

    public long getTripleCount() {
        return ((VerifyStatementBufferFactory)this.bufferFactory).ntriples.get();
    }

    public long getTripleNotFoundCount() {
        return ((VerifyStatementBufferFactory)this.bufferFactory).ntriplesNotFound.get();
    }

    public String reportTotals() {
        long elapsed = this.elapsed();
        long tripleCount = this.getTripleCount();
        double tps = (long)((double)tripleCount / (double)elapsed * 1000.0);
        return "Processed: #terms=" + this.getTermCount() + " (" + this.getTermNotFoundCount() + " not found), #stmts=" + tripleCount + " (" + this.getTripleNotFoundCount() + " not found)" + ", rate=" + tps + " in " + elapsed + " ms.";
    }
}

