/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.BTree;

public class TermIdEncoder {
    private final int N;
    private final int mask;

    public String toString() {
        return this.getClass().getName() + "{N=" + this.N + ", mask=" + Integer.toBinaryString(this.mask) + "}";
    }

    public int getNBits() {
        return this.N;
    }

    public TermIdEncoder(int N) {
        if (N < 0) {
            throw new IllegalArgumentException();
        }
        if (N > 31) {
            throw new IllegalArgumentException();
        }
        this.N = N;
        int mask = 0;
        for (int i = 0; i < N; ++i) {
            int bit = 1 << i;
            mask |= bit;
        }
        this.mask = mask;
    }

    public long encode(long v) {
        if (v == 0L) {
            throw new IllegalArgumentException();
        }
        long pid = 0xFFFFFFFFL & (long)TermIdEncoder.getPartitionId(v);
        long ctr = 0xFFFFFFFFL & (long)TermIdEncoder.getLocalCounter(v);
        long u = 0L;
        u |= pid << 32 - this.N;
        u |= ctr >>> this.N;
        long rev = Integer.reverse((int)ctr & this.mask);
        return u |= rev << 32;
    }

    public long decode(long u) {
        int fwd = Integer.reverse((int)(u >>> 32)) & this.mask;
        int ctr = (int)(u << this.N) | fwd;
        int pid = (int)(u >>> 32 - this.N);
        return TermIdEncoder.combine(pid, ctr);
    }

    public static int getPartitionId(long v) {
        return BTree.PartitionedCounter.getPartitionId(v);
    }

    public static int getLocalCounter(long v) {
        return BTree.PartitionedCounter.getLocalCounter(v);
    }

    public static long combine(int pid, int ctr) {
        return BTree.PartitionedCounter.combine(pid, ctr);
    }

    long encode2(long v1) {
        long v2 = v1 >>> this.N;
        for (int b = 0; b < this.N; ++b) {
            if ((v1 & 1L << b) == 0L) continue;
            long sv = 1L << 63 - b;
            v2 |= sv;
        }
        return v2;
    }

    long decode2(long v2) {
        long v1 = v2 << this.N;
        for (int b = 0; b < this.N; ++b) {
            if ((v2 & 1L << 63 - b) == 0L) continue;
            v1 |= 1L << b;
        }
        return v1;
    }
}

