/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XSDUnsignedIntIV<V extends BigdataLiteral>
extends AbstractLiteralIV<V, Long> {
    private static final long serialVersionUID = 1L;
    private final int value;
    private static final int UNSIGNED_ZERO = Integer.MIN_VALUE;

    public int rawValue() {
        return this.value;
    }

    @Override
    public IV<V, Long> clone(boolean clearCache) {
        XSDUnsignedIntIV tmp = new XSDUnsignedIntIV(this.value);
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public XSDUnsignedIntIV(int value) {
        super(DTE.XSDUnsignedInt);
        this.value = value;
    }

    public final long promote() {
        return XSDUnsignedIntIV.promote(this.value);
    }

    public static long promote(int value) {
        long v = (long)value - Integer.MIN_VALUE;
        return v;
    }

    @Override
    public final Long getInlineValue() {
        return this.promote();
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataLiteral v = (BigdataLiteral)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            v = f.createLiteral(this.value, true);
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public final long longValue() {
        return this.promote();
    }

    @Override
    public boolean booleanValue() {
        return this.value != Integer.MIN_VALUE;
    }

    @Override
    public byte byteValue() {
        return (byte)this.promote();
    }

    @Override
    public double doubleValue() {
        return this.promote();
    }

    @Override
    public float floatValue() {
        return this.promote();
    }

    @Override
    public int intValue() {
        return (int)this.promote();
    }

    @Override
    public short shortValue() {
        return (short)this.promote();
    }

    @Override
    public String stringValue() {
        return Long.toString(this.promote());
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this.promote());
    }

    @Override
    public BigInteger integerValue() {
        return BigInteger.valueOf(this.promote());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof XSDUnsignedIntIV) {
            return this.value == ((XSDUnsignedIntIV)o).value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public int byteLength() {
        return 5;
    }

    @Override
    public int _compareTo(IV o) {
        XSDUnsignedIntIV t = (XSDUnsignedIntIV)o;
        return this.value == t.value ? 0 : (this.value < t.value ? -1 : 1);
    }
}

