/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.extensions;

import com.bigdata.btree.keys.DefaultKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.impl.extensions.InvalidGeoSpatialLiteralError;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.service.geospatial.GeoSpatialDatatypeConfiguration;
import com.bigdata.service.geospatial.GeoSpatialDatatypeFieldConfiguration;
import com.bigdata.service.geospatial.IGeoSpatialLiteralSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;

public class GeoSpatialLiteralExtension<V extends BigdataValue>
implements IExtension<V> {
    private static final int BASE_SIZE = 8;
    private final IGeoSpatialLiteralSerializer litSerializer;
    private final BigdataURI datatype;
    private final GeoSpatialDatatypeConfiguration datatypeConfig;
    private final IKeyBuilderFactory kbfactory;

    public GeoSpatialLiteralExtension(IDatatypeURIResolver resolver, GeoSpatialDatatypeConfiguration config) {
        this.datatype = resolver.resolve(config.getUri());
        this.datatypeConfig = config;
        this.litSerializer = config.getLiteralSerializer();
        this.kbfactory = new DefaultKeyBuilderFactory(new Properties());
    }

    private IKeyBuilder getKeyBuilder() {
        return this.kbfactory.getKeyBuilder();
    }

    @Override
    public Set<BigdataURI> getDatatypes() {
        LinkedHashSet<BigdataURI> datatypes = new LinkedHashSet<BigdataURI>();
        datatypes.add(this.datatype);
        return datatypes;
    }

    @Override
    public LiteralExtensionIV createIV(Value value) {
        if (!(value instanceof Literal)) {
            throw new IllegalArgumentException("Value not a literal");
        }
        return this.createIV(this.litSerializer.toComponents(value.stringValue()));
    }

    public LiteralExtensionIV createIV(Object[] components) {
        long[] componentsAsLongArr = this.componentsAsLongArr(components, this.datatypeConfig);
        byte[] zOrderByteArray = this.toZOrderByteArray(componentsAsLongArr, this.datatypeConfig);
        byte[] zOrderByteArrayTwoCompl = this.padLeadingZero(zOrderByteArray);
        BigInteger bi = new BigInteger(zOrderByteArrayTwoCompl);
        XSDIntegerIV<BigdataLiteral> delegate = new XSDIntegerIV<BigdataLiteral>(bi);
        return new LiteralExtensionIV(delegate, this.datatype.getIV());
    }

    public byte[] toZOrderByteArray(Object[] components) {
        long[] componentsAsLongArr = this.componentsAsLongArr(components, this.datatypeConfig);
        byte[] zOrderByteArray = this.toZOrderByteArray(componentsAsLongArr, this.datatypeConfig);
        return this.padLeadingZero(zOrderByteArray);
    }

    public LiteralExtensionIV createIVFromZOrderByteArray(byte[] zOrderByteArray) {
        byte[] zOrderByteArrayTwoCompl = this.padLeadingZero(zOrderByteArray);
        BigInteger bi = new BigInteger(zOrderByteArrayTwoCompl);
        XSDIntegerIV<BigdataLiteral> delegate = new XSDIntegerIV<BigdataLiteral>(bi);
        return new LiteralExtensionIV(delegate, this.datatype.getIV());
    }

    public final long[] componentsAsLongArr(Object[] components, GeoSpatialDatatypeConfiguration datatypeConfig) {
        int numDimensions = datatypeConfig.getNumDimensions();
        long[] ret = new long[numDimensions];
        if (numDimensions != components.length) {
            throw new InvalidGeoSpatialLiteralError("Literal value has wrong format. Expected " + numDimensions + " components for datatype, but literal has " + components.length + " components.");
        }
        try {
            block6: for (int i = 0; i < components.length; ++i) {
                Object component = components[i];
                GeoSpatialDatatypeFieldConfiguration fieldConfig = datatypeConfig.getFields().get(i);
                switch (fieldConfig.getValueType()) {
                    case DOUBLE: {
                        Number precisionAdjustment = BigDecimal.valueOf(fieldConfig.getMultiplier());
                        BigDecimal componentAsBigDecimal = component instanceof BigDecimal ? (BigDecimal)component : new BigDecimal(component.toString());
                        Number x = ((BigDecimal)precisionAdjustment).multiply(componentAsBigDecimal);
                        ret[i] = ((BigDecimal)x).longValue();
                        continue block6;
                    }
                    case LONG: {
                        Number precisionAdjustment = BigInteger.valueOf(fieldConfig.getMultiplier());
                        BigInteger componentAsBigInteger = component instanceof BigInteger ? (BigInteger)component : new BigInteger(component.toString());
                        Number x = ((BigInteger)precisionAdjustment).multiply(componentAsBigInteger);
                        ret[i] = ((BigInteger)x).longValue();
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid field configuration: value type not supported.");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new InvalidGeoSpatialLiteralError(e.getMessage());
        }
        return ret;
    }

    public byte[] toZOrderByteArray(long[] componentsAsLongArr, GeoSpatialDatatypeConfiguration datatypeConfig) {
        IKeyBuilder kb = this.getKeyBuilder();
        kb.reset();
        for (int i = 0; i < componentsAsLongArr.length; ++i) {
            long componentAsLong = componentsAsLongArr[i];
            Long minValue = datatypeConfig.getFields().get(i).getMinValue();
            long componentAsLongRangeShifted = minValue == null ? componentAsLong : this.encodeRangeShift(componentAsLong, minValue);
            kb.append(componentAsLongRangeShifted);
        }
        return kb.toZOrder(datatypeConfig.getNumDimensions());
    }

    protected Long encodeRangeShift(Long val, Long minValue) {
        if (minValue == null) {
            return val;
        }
        if (val < minValue) {
            throw new RuntimeException("Illegal range shift -- datatype violation.");
        }
        return Long.MIN_VALUE + (val - minValue);
    }

    public byte[] padLeadingZero(byte[] arr) {
        byte[] ret = new byte[arr.length + 1];
        for (int i = 0; i < arr.length; ++i) {
            ret[i + 1] = arr[i];
        }
        return ret;
    }

    @Override
    public V asValue(LiteralExtensionIV iv, BigdataValueFactory vf) {
        long[] componentsAsLongArr = this.asLongArray(iv);
        Object[] componentArr = this.longArrAsComponentArr(componentsAsLongArr);
        String litStr = this.litSerializer.fromComponents(componentArr);
        return (V)vf.createLiteral(litStr, this.datatype);
    }

    public long[] asLongArray(LiteralExtensionIV iv) {
        if (!this.datatype.getIV().equals(iv.getExtensionIV())) {
            throw new IllegalArgumentException("unrecognized datatype");
        }
        BigInteger bigInt = iv.getDelegate().integerValue();
        byte[] bigIntAsByteArrUnsigned = this.toZOrderByteArray(bigInt);
        long[] componentsAsLongArr = this.fromZOrderByteArray(bigIntAsByteArrUnsigned);
        return componentsAsLongArr;
    }

    public Object[] toComponentArray(LiteralExtensionIV iv) {
        long[] longArr = this.asLongArray(iv);
        return this.longArrAsComponentArr(longArr);
    }

    public byte[] toZOrderByteArray(BigInteger bigInt) {
        int i;
        int numDimensions = this.datatypeConfig.getNumDimensions();
        byte[] bigIntAsByteArr = bigInt.toByteArray();
        int paddedArraySize = numDimensions * 8 + 1;
        byte[] bigIntAsByteArrPad = new byte[paddedArraySize];
        int idx = 0;
        for (i = 0; i < paddedArraySize - bigIntAsByteArr.length; ++i) {
            bigIntAsByteArrPad[idx++] = 0;
        }
        for (i = 0; i < bigIntAsByteArr.length; ++i) {
            bigIntAsByteArrPad[idx++] = bigIntAsByteArr[i];
        }
        byte[] bigIntAsByteArrUnsigned = this.unpadLeadingZero(bigIntAsByteArrPad);
        return bigIntAsByteArrUnsigned;
    }

    public byte[] toZOrderByteArray(AbstractLiteralIV<BigdataLiteral, ?> literalIV) {
        if (!(literalIV instanceof XSDIntegerIV)) {
            throw new RuntimeException("zOrder value IV must be XSDInteger");
        }
        return this.toZOrderByteArray(literalIV.integerValue());
    }

    public long[] fromZOrderByteArray(byte[] byteArr) {
        IKeyBuilder kb = this.getKeyBuilder();
        kb.reset();
        for (int i = 0; i < byteArr.length; ++i) {
            kb.append(byteArr[i]);
        }
        long[] componentsAsLongArr = kb.fromZOrder(this.datatypeConfig.getNumDimensions());
        for (int i = 0; i < componentsAsLongArr.length; ++i) {
            Long minValue = this.datatypeConfig.getFields().get(i).getMinValue();
            if (minValue == null) continue;
            componentsAsLongArr[i] = this.decodeRangeShift(componentsAsLongArr[i], minValue);
        }
        return componentsAsLongArr;
    }

    protected Long decodeRangeShift(Long val, Long minValue) {
        if (minValue == null) {
            return val;
        }
        return val - Long.MIN_VALUE + minValue;
    }

    public final Object[] longArrAsComponentArr(long[] arr) {
        int numDimensions = this.datatypeConfig.getNumDimensions();
        if (arr.length != numDimensions) {
            throw new IllegalArgumentException("Encoding has wrong format. Expected " + numDimensions + " components for datatype.");
        }
        Object[] componentArr = new Object[arr.length];
        block4: for (int i = 0; i < arr.length; ++i) {
            GeoSpatialDatatypeFieldConfiguration fieldConfig = this.datatypeConfig.getFields().get(i);
            double precisionAdjustment = fieldConfig.getMultiplier();
            switch (fieldConfig.getValueType()) {
                case DOUBLE: {
                    componentArr[i] = (double)arr[i] / precisionAdjustment;
                    continue block4;
                }
                case LONG: {
                    componentArr[i] = arr[i] / (long)precisionAdjustment;
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Uncovered decoding case. Please fix code.");
                }
            }
        }
        return componentArr;
    }

    public byte[] unpadLeadingZero(byte[] arr) {
        byte[] ret = new byte[arr.length - 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = arr[i + 1];
        }
        return ret;
    }

    public int getNumDimensions() {
        return this.datatypeConfig.getNumDimensions();
    }

    public GeoSpatialDatatypeConfiguration getDatatypeConfig() {
        return this.datatypeConfig;
    }
}

