/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.encoder;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IndexAnnotations;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BloomFilterFactory;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.raba.codec.FrontCodedRabaCoder;
import com.bigdata.btree.raba.codec.SimpleRabaCoder;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.encoder.IVBindingSetEncoder;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.rdf.lexicon.BlobsTupleSerializer;
import com.bigdata.rdf.lexicon.Id2TermTupleSerializer;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

@Deprecated
public class IVBindingSetEncoderWithIVCache
extends IVBindingSetEncoder {
    private final String namespace;
    private final BigdataValueFactory valueFactory;
    protected final LinkedHashSet<IVariable<?>> ivCacheSchema;
    final Map<IV<?, ?>, BigdataValue> cache;
    private final AtomicReference<BTree> ivCache = new AtomicReference();
    private final AtomicReference<BTree> blobsCache = new AtomicReference();
    private final AtomicReference<BTree> literalExtensionIVCache = new AtomicReference();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{namespace=" + this.namespace);
        if (this.ivCache.get() != null) {
            sb.append(",ivCacheSize=" + this.getIVCacheSize());
        }
        if (this.blobsCache.get() != null) {
            sb.append(",blobCacheSize=" + this.getBlobsCacheSize());
        }
        sb.append("}");
        return sb.toString();
    }

    private long getIVCacheSize() {
        BTree ndx = this.ivCache.get();
        if (ndx != null) {
            return ndx.getEntryCount();
        }
        return 0L;
    }

    private long getLiteralExtensionIVCacheSize() {
        BTree ndx = this.literalExtensionIVCache.get();
        if (ndx != null) {
            return ndx.getEntryCount();
        }
        return 0L;
    }

    private long getBlobsCacheSize() {
        BTree ndx = this.blobsCache.get();
        if (ndx != null) {
            return ndx.getEntryCount();
        }
        return 0L;
    }

    private IndexMetadata getIVCacheIndexMetadata(BOp op) {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        int branchingFactor = 256;
        int ratio = 32;
        metadata.setBranchingFactor(256);
        metadata.setWriteRetentionQueueCapacity((Integer)op.getProperty(IndexAnnotations.WRITE_RETENTION_QUEUE_CAPACITY, (Object)4000));
        metadata.setTupleSerializer(new Id2TermTupleSerializer(this.namespace, this.valueFactory, new ASCIIKeyBuilderFactory(8), new FrontCodedRabaCoder(32), SimpleRabaCoder.INSTANCE));
        metadata.setBloomFilterFactory(BloomFilterFactory.DEFAULT);
        metadata.setRawRecords(true);
        metadata.setMaxRecLen(16);
        return metadata;
    }

    private IndexMetadata getLiteralExtensionIVCacheIndexMetadata(BOp op) {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        int branchingFactor = 256;
        int ratio = 32;
        metadata.setBranchingFactor(256);
        metadata.setWriteRetentionQueueCapacity((Integer)op.getProperty(IndexAnnotations.WRITE_RETENTION_QUEUE_CAPACITY, (Object)4000));
        metadata.setTupleSerializer(new Id2TermTupleSerializer(this.namespace, this.valueFactory, new ASCIIKeyBuilderFactory(8), new FrontCodedRabaCoder(32), SimpleRabaCoder.INSTANCE));
        metadata.setBloomFilterFactory(BloomFilterFactory.DEFAULT);
        metadata.setRawRecords(true);
        metadata.setMaxRecLen(16);
        return metadata;
    }

    private IndexMetadata getBlobsCacheIndexMetadata(BOp op) {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setTupleSerializer(new BlobsTupleSerializer(this.namespace, this.valueFactory));
        metadata.setRawRecords(true);
        metadata.setMaxRecLen(0);
        int branchingFactor = 256;
        metadata.setBranchingFactor(256);
        metadata.setWriteRetentionQueueCapacity((Integer)op.getProperty(IndexAnnotations.WRITE_RETENTION_QUEUE_CAPACITY, (Object)4000));
        metadata.setBloomFilterFactory(BloomFilterFactory.DEFAULT);
        return metadata;
    }

    public IVBindingSetEncoderWithIVCache(IRawStore store, boolean filter, BOp op) {
        super(BigdataValueFactoryImpl.getInstance(((String[])op.getRequiredProperty(Predicate.Annotations.RELATION_NAME))[0]), filter);
        if (!filter) {
            this.namespace = ((String[])op.getRequiredProperty(Predicate.Annotations.RELATION_NAME))[0];
            this.valueFactory = BigdataValueFactoryImpl.getInstance(this.namespace);
            this.ivCache.set(BTree.create(store, this.getIVCacheIndexMetadata(op)));
            this.literalExtensionIVCache.set(BTree.create(store, this.getLiteralExtensionIVCacheIndexMetadata(op)));
            this.blobsCache.set(BTree.create(store, this.getBlobsCacheIndexMetadata(op)));
            this.ivCacheSchema = new LinkedHashSet();
            this.cache = new HashMap();
        } else {
            this.namespace = null;
            this.valueFactory = null;
            this.ivCacheSchema = null;
            this.cache = null;
        }
    }

    @Override
    public boolean isValueCache() {
        return !this.filter;
    }

    public void saveSolutionSet() {
        this.flush();
        this.checkpointBTree(this.ivCache);
        this.checkpointBTree(this.literalExtensionIVCache);
        this.checkpointBTree(this.blobsCache);
    }

    private void checkpointBTree(AtomicReference<BTree> ref) {
        BTree tmp = ref.get();
        if (tmp != null) {
            Checkpoint checkpoint = tmp.writeCheckpoint2();
            BTree readOnly = BTree.load(tmp.getStore(), checkpoint.getCheckpointAddr(), true);
            if (!ref.compareAndSet(tmp, readOnly)) {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void release() {
        BTree tmp2 = this.ivCache.getAndSet(null);
        if (tmp2 != null) {
            tmp2.close();
        }
        if ((tmp2 = (BTree)this.blobsCache.getAndSet(null)) != null) {
            tmp2.close();
        }
        if ((tmp2 = (BTree)this.literalExtensionIVCache.getAndSet(null)) != null) {
            tmp2.close();
        }
        if (this.ivCacheSchema != null) {
            this.ivCacheSchema.clear();
        }
        super.release();
    }

    @Override
    public void flush() {
        if (this.filter) {
            super.flush();
            return;
        }
        BTree ivCache = this.ivCache.get();
        BTree blobsCache = this.blobsCache.get();
        BTree literalExtensionIVCache = this.literalExtensionIVCache.get();
        BlobsIndexHelper h = null;
        Id2TermTupleSerializer tupSer = (Id2TermTupleSerializer)ivCache.getIndexMetadata().getTupleSerializer();
        for (Map.Entry<IV<?, ?>, BigdataValue> e : this.cache.entrySet()) {
            byte[] val;
            byte[] key;
            IKeyBuilder keyBuilder;
            IV<?, ?> iv = e.getKey();
            BigdataValue value = e.getValue();
            if (iv instanceof BlobIV) {
                if (h == null) {
                    h = new BlobsIndexHelper();
                }
                keyBuilder = h.newKeyBuilder();
                key = iv.encode(keyBuilder.reset()).getKey();
                val = this.valueFactory.getValueSerializer().serialize(value);
                if (blobsCache.contains(key)) continue;
                blobsCache.insert(key, val);
                continue;
            }
            if (iv instanceof LiteralExtensionIV) {
                keyBuilder = new KeyBuilder();
                key = iv.encode(keyBuilder.reset()).getKey();
                val = this.valueFactory.getValueSerializer().serialize(value);
                if (literalExtensionIVCache.contains(key)) continue;
                literalExtensionIVCache.insert(key, val);
                continue;
            }
            byte[] key2 = tupSer.serializeKey(iv);
            if (ivCache.contains(key2)) continue;
            ivCache.insert(key2, tupSer.serializeVal(value));
        }
        if (this.cache != null) {
            this.cache.clear();
        }
        super.flush();
    }

    @Override
    public void resolveCachedValues(IBindingSet bset) {
        BTree ivCache = this.ivCache.get();
        BTree literalExtensionIVCache = this.literalExtensionIVCache.get();
        BTree blobsCache = this.blobsCache.get();
        if (!(ivCache != null && ivCache.getEntryCount() != 0L || literalExtensionIVCache != null && literalExtensionIVCache.getEntryCount() != 0L || blobsCache != null && blobsCache.getEntryCount() != 0L)) {
            return;
        }
        Id2TermTupleSerializer tupSer = (Id2TermTupleSerializer)ivCache.getIndexMetadata().getTupleSerializer();
        IKeyBuilder keyBuilder = tupSer.getKeyBuilder();
        Tuple ivCacheTuple = new Tuple(ivCache, 3);
        BlobsIndexHelper h = null;
        for (Map.Entry e : bset) {
            BigdataValue value;
            IV iv;
            IVariable v = (IVariable)e.getKey();
            if (!this.ivCacheSchema.contains(v) || (iv = (IV)((IConstant)e.getValue()).get()).hasValue()) continue;
            keyBuilder.reset();
            if (iv instanceof BlobIV) {
                byte[] val;
                BlobIV blobIV = (BlobIV)iv;
                if (h == null) {
                    h = new BlobsIndexHelper();
                }
                if ((val = h.lookup(blobsCache, blobIV, keyBuilder)) == null) continue;
                value = this.valueFactory.getValueSerializer().deserialize(val);
                iv.setValue(value);
                continue;
            }
            if (iv instanceof LiteralExtensionIV) {
                LiteralExtensionIV literalExtensionIv = (LiteralExtensionIV)iv;
                IVUtility.encode(keyBuilder, literalExtensionIv);
                byte[] key = keyBuilder.getKey();
                if (literalExtensionIVCache.lookup(key, ivCacheTuple) == null) continue;
                value = tupSer.deserialize(ivCacheTuple);
                iv.setValue(value);
                continue;
            }
            IVUtility.encode(keyBuilder, iv);
            byte[] key = keyBuilder.getKey();
            if (ivCache.lookup(key, ivCacheTuple) == null) continue;
            BigdataValue value2 = tupSer.deserialize(ivCacheTuple);
            iv.setValue(value2);
        }
    }

    @Override
    void cacheSchemaAndValue(IVariable<?> v, IV<?, ?> iv, boolean updateCache) {
        if (iv.needsMaterialization() && iv.hasValue() && !this.filter) {
            this.ivCacheSchema.add(v);
            if (updateCache && this.cache != null) {
                this.cache.put(iv, (BigdataValue)iv.getValue());
            }
        }
    }
}

