/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.math.BigInteger;
import java.util.Map;
import org.openrdf.model.Literal;

public class StrlenBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 4176318782528605454L;

    public StrlenBOp(IValueExpression<? extends IV> x, GlobalAnnotations globals) {
        super(x, globals, new NV[0]);
    }

    public StrlenBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
    }

    public StrlenBOp(StrlenBOp op) {
        super(op);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    public IV get(IBindingSet bs) throws SparqlTypeErrorException {
        Literal lit = this.getAndCheckLiteralValue(0, bs);
        String label = lit.getLabel();
        int length = label.length();
        return new XSDIntegerIV(BigInteger.valueOf(length));
    }
}

