/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import java.util.Map;

public class AndBOp
extends XSDBooleanIVValueExpression {
    private static final long serialVersionUID = -1217715173822304819L;

    public AndBOp(IValueExpression<? extends IV> x, IValueExpression<? extends IV> y) {
        this(new BOp[]{AndBOp.wrap(x), AndBOp.wrap(y)}, BOp.NOANNS);
    }

    public AndBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 2 || args[0] == null || args[1] == null) {
            throw new IllegalArgumentException();
        }
        if (!(args[0] instanceof XSDBooleanIVValueExpression)) {
            throw new IllegalArgumentException();
        }
        if (!(args[1] instanceof XSDBooleanIVValueExpression)) {
            throw new IllegalArgumentException();
        }
    }

    public AndBOp(AndBOp op) {
        super(op);
    }

    @Override
    public XSDBooleanIVValueExpression get(int i) {
        return (XSDBooleanIVValueExpression)super.get(i);
    }

    @Override
    public boolean accept(IBindingSet bs) {
        XSDBooleanIV right;
        XSDBooleanIV left;
        try {
            left = this.get(0).get(bs);
        }
        catch (SparqlTypeErrorException ex) {
            left = null;
        }
        try {
            right = this.get(1).get(bs);
        }
        catch (SparqlTypeErrorException ex) {
            right = null;
        }
        if (left == null || right == null) {
            if (left != null && !left.booleanValue()) {
                return false;
            }
            if (right != null && !right.booleanValue()) {
                return false;
            }
            throw new SparqlTypeErrorException();
        }
        return left.booleanValue() && right.booleanValue();
    }
}

