/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.rdf.graph.IGASScheduler;
import com.bigdata.rdf.graph.IGASSchedulerImpl;
import com.bigdata.rdf.graph.IStaticFrontier;
import com.bigdata.rdf.graph.impl.GASEngine;
import com.bigdata.rdf.graph.impl.bd.MergeSortIterator;
import com.bigdata.rdf.graph.impl.scheduler.STScheduler;
import com.bigdata.rdf.graph.impl.util.GASImplUtil;
import com.bigdata.rdf.graph.impl.util.IArraySlice;
import com.bigdata.rdf.graph.impl.util.IManagedArray;
import com.bigdata.rdf.graph.impl.util.ManagedArray;
import com.bigdata.rdf.graph.util.GASUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.openrdf.model.Value;

public class TLScheduler
implements IGASSchedulerImpl {
    private final GASEngine gasEngine;
    private final int nthreads;
    private final ConcurrentHashMap<Long, MySTScheduler> map;

    public TLScheduler(GASEngine gasEngine) {
        this.gasEngine = gasEngine;
        this.nthreads = gasEngine.getNThreads();
        this.map = new ConcurrentHashMap(this.nthreads, 0.75f, this.nthreads);
    }

    private IGASScheduler threadLocalScheduler() {
        IGASScheduler old;
        Long id = Thread.currentThread().getId();
        MySTScheduler s = this.map.get(id);
        if (s == null && (old = (IGASScheduler)this.map.putIfAbsent(id, s = new MySTScheduler(this.gasEngine))) != null) {
            throw new AssertionError();
        }
        return s;
    }

    public void schedule(Value v) {
        this.threadLocalScheduler().schedule(v);
    }

    public void clear() {
        this.map.clear();
    }

    public void compactFrontier(IStaticFrontier frontier) {
        List futures;
        IArraySlice[] frontiers = new IArraySlice[this.nthreads];
        int nsources = 0;
        int nvertices = 0;
        ArrayList<1> tasks = new ArrayList<1>(this.nthreads);
        Iterator<MySTScheduler> i$ = this.map.values().iterator();
        while (i$.hasNext()) {
            MySTScheduler s;
            final MySTScheduler t = s = i$.next();
            tasks.add(new Callable<IArraySlice<Value>>(){

                @Override
                public IArraySlice<Value> call() throws Exception {
                    return GASImplUtil.compactAndSort((Set)t.getVertices(), (IManagedArray)t.tmp);
                }
            });
        }
        try {
            futures = this.gasEngine.getGASThreadPool().invokeAll(tasks);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        for (Future f : futures) {
            try {
                IArraySlice b = frontiers[nsources] = (IArraySlice)f.get();
                nvertices += b.len();
                ++nsources;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        if (nvertices == 0) {
            frontier.resetFrontier(0, false, GASUtil.EMPTY_VERTICES_ITERATOR);
            return;
        }
        if (nsources > this.nthreads) {
            throw new AssertionError((Object)("nsources=" + nsources + ", nthreads=" + this.nthreads));
        }
        this.mergeSortSourcesAndSetFrontier(nsources, nvertices, frontiers, frontier);
    }

    private void mergeSortSourcesAndSetFrontier(int nsources, int nvertices, IArraySlice<Value>[] frontiers, IStaticFrontier frontier) {
        Iterator[] itrs = new Iterator[nsources];
        for (int i = 0; i < nsources; ++i) {
            itrs[i] = frontiers[i].iterator();
        }
        MergeSortIterator itr = new MergeSortIterator(itrs);
        frontier.resetFrontier(nvertices, false, (Iterator)itr);
    }

    private static class MySTScheduler
    extends STScheduler {
        private final ManagedArray<Value> tmp = new ManagedArray(Value.class, 64);

        public MySTScheduler(GASEngine gasEngine) {
            super(gasEngine);
        }
    }
}

