/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.error;

import com.bigdata.util.NV;
import java.util.Formatter;

public class W3CQueryLanguageException
extends RuntimeException {
    protected static final transient String err = "http://www.w3.org/2005/xqt-errors";
    private static final long serialVersionUID = 1L;
    public final LanguageFamily languageFamily;
    public final ErrorCategory errorCategory;
    public final int errorCode;

    protected W3CQueryLanguageException(LanguageFamily languageFamily, ErrorCategory errorCategory, int errorCode) {
        super(W3CQueryLanguageException.toURI(languageFamily, errorCategory, errorCode, null));
        this.languageFamily = languageFamily;
        this.errorCategory = errorCategory;
        this.errorCode = errorCode;
    }

    protected W3CQueryLanguageException(LanguageFamily languageFamily, ErrorCategory errorCategory, int errorCode, String msg) {
        super(msg == null ? W3CQueryLanguageException.toURI(languageFamily, errorCategory, errorCode, null) : msg);
        this.languageFamily = languageFamily;
        this.errorCategory = errorCategory;
        this.errorCode = errorCode;
    }

    protected W3CQueryLanguageException(LanguageFamily languageFamily, ErrorCategory errorCategory, int errorCode, NV[] params) {
        super(W3CQueryLanguageException.toURI(languageFamily, errorCategory, errorCode, params));
        this.languageFamily = languageFamily;
        this.errorCategory = errorCategory;
        this.errorCode = errorCode;
    }

    protected static String toURI(LanguageFamily languageFamily, ErrorCategory errorCategory, int errorCode, NV[] params) {
        if (errorCode >= 10000 || errorCode < 0) {
            throw new IllegalArgumentException();
        }
        AbstractStringBuilder sb = new StringBuffer(4);
        Formatter f = new Formatter(sb);
        f.format("%04d", errorCode);
        String uri = err + (Object)((Object)languageFamily) + (Object)((Object)errorCategory) + ((StringBuffer)sb).toString();
        if (params == null || params.length == 0) {
            return uri;
        }
        sb = new StringBuilder();
        ((StringBuilder)sb).append(uri);
        for (int i = 0; i < params.length; ++i) {
            NV nv = params[i];
            ((StringBuilder)sb).append(i == 0 ? (char)'?' : '&');
            ((StringBuilder)sb).append(W3CQueryLanguageException.encode(nv.getName()));
            ((StringBuilder)sb).append('=');
            ((StringBuilder)sb).append(W3CQueryLanguageException.encode(nv.getValue()));
        }
        return ((StringBuilder)sb).toString();
    }

    private static String encode(String s) {
        if (s == null) {
            return W3CQueryLanguageException.encode("null");
        }
        return s;
    }

    public static enum ErrorCategory {
        ST,
        DY,
        TY;

    }

    public static enum LanguageFamily {
        XQ,
        XP,
        SP;

    }
}

