/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.changesets;

import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public class DelegatingChangeLog
implements IChangeLog {
    private static final transient Logger log = Logger.getLogger(DelegatingChangeLog.class);
    private final CopyOnWriteArraySet<IChangeLog> delegates = new CopyOnWriteArraySet();

    public String toString() {
        return this.getClass().getName() + "{delegates=" + this.delegates.toString() + "}";
    }

    public void addDelegate(IChangeLog delegate) {
        this.delegates.add(delegate);
    }

    public void removeDelegate(IChangeLog delegate) {
        this.delegates.remove(delegate);
    }

    @Override
    public void changeEvent(IChangeRecord record) {
        if (log.isInfoEnabled()) {
            log.info((Object)record);
        }
        for (IChangeLog delegate : this.delegates) {
            delegate.changeEvent(record);
        }
    }

    @Override
    public void transactionBegin() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        for (IChangeLog delegate : this.delegates) {
            delegate.transactionBegin();
        }
    }

    @Override
    public void transactionPrepare() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        for (IChangeLog delegate : this.delegates) {
            delegate.transactionPrepare();
        }
    }

    @Override
    public void transactionCommited(long commitTime) {
        if (log.isInfoEnabled()) {
            log.info((Object)"transaction committed");
        }
        for (IChangeLog delegate : this.delegates) {
            delegate.transactionCommited(commitTime);
        }
    }

    @Override
    public void transactionAborted() {
        if (log.isInfoEnabled()) {
            log.info((Object)"transaction aborted");
        }
        for (IChangeLog delegate : this.delegates) {
            delegate.transactionAborted();
        }
    }

    @Override
    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)"close");
        }
        for (IChangeLog delegate : this.delegates) {
            delegate.close();
        }
    }
}

