/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.CommitRecordIndex;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.journal.RWStrategy;
import com.bigdata.rwstore.RWStore;
import java.io.File;
import java.util.Properties;

public class VerifyCommitRecordIndex {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: <journal filename>");
            return;
        }
        String fname = args[0];
        File f = new File(fname);
        if (!f.exists()) {
            System.err.println("File: " + fname + " not found");
            return;
        }
        Properties props = new Properties();
        props.setProperty(Options.FILE, fname);
        Journal jrnl = new Journal(props);
        if (jrnl.getBufferStrategy().getBufferMode() != BufferMode.DiskRW) {
            System.err.println("Buffer mode should be DiskRW not " + (Object)((Object)jrnl.getBufferStrategy().getBufferMode()));
            return;
        }
        RWStrategy rwstrategy = (RWStrategy)jrnl.getBufferStrategy();
        RWStore rwstore = rwstrategy.getStore();
        CommitRecordIndex commitRecordIndex = jrnl.getReadOnlyCommitRecordIndex();
        if (commitRecordIndex == null) {
            System.err.println("Unexpected null commit record index");
            return;
        }
        IndexMetadata metadata = commitRecordIndex.getIndexMetadata();
        byte[] zeroKey = metadata.getTupleSerializer().serializeKey(0L);
        byte[] releaseKey = metadata.getTupleSerializer().serializeKey(rwstore.getLastReleaseTime());
        int removed = jrnl.removeCommitRecordEntries(zeroKey, releaseKey);
        System.out.println("Commit Record Index verified with " + removed + " records removed");
        jrnl.commit();
    }
}

