/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.journal.AbstractTask;
import com.bigdata.journal.ConcurrencyManager;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.IConcurrencyManager;
import com.bigdata.journal.ILocalTransactionManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.RunState;
import com.bigdata.journal.Tx;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.AbstractHATransactionService;
import com.bigdata.service.AbstractTransactionService;
import java.util.Properties;
import java.util.concurrent.ExecutionException;

public abstract class JournalTransactionService
extends AbstractHATransactionService {
    private final Journal journal;

    public JournalTransactionService(Properties properties, Journal journal) {
        super(properties);
        this.journal = journal;
    }

    @Override
    public JournalTransactionService start() {
        super.start();
        return this;
    }

    @Override
    protected void activateTx(AbstractTransactionService.TxState state) {
        super.activateTx(state);
        new Tx(this.journal.getLocalTransactionManager(), this.journal, state.tx, state.getReadsOnCommitTime());
    }

    @Override
    protected void deactivateTx(AbstractTransactionService.TxState state) {
        super.deactivateTx(state);
        Tx localState = this.journal.getLocalTransactionManager().getTx(state.tx);
        if (localState != null) {
            this.journal.getLocalTransactionManager().deactivateTx(localState);
        }
    }

    @Override
    protected long findCommitTime(long timestamp) {
        ICommitRecord commitRecord = this.journal.getCommitRecord(timestamp);
        if (commitRecord == null) {
            return -1L;
        }
        return commitRecord.getTimestamp();
    }

    @Override
    protected long findNextCommitTime(long commitTime) {
        ICommitRecord commitRecord = this.journal.getCommitRecordStrictlyGreaterThan(commitTime);
        if (commitRecord == null) {
            return -1L;
        }
        return commitRecord.getTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void abortImpl(AbstractTransactionService.TxState state) {
        if (state.isReadOnly()) {
            state.setRunState(RunState.Aborted);
            return;
        }
        try {
            Tx localState = this.journal.getLocalTransactionManager().getTx(state.tx);
            if (localState == null) {
                throw new AssertionError((Object)("Local tx state not found: tx=" + state));
            }
            localState.lock.lock();
            try {
                localState.setRunState(RunState.Aborted);
            }
            finally {
                localState.lock.unlock();
            }
        }
        finally {
            state.setRunState(RunState.Aborted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long commitImpl(AbstractTransactionService.TxState state) throws ExecutionException, InterruptedException {
        if (state.isReadOnly()) {
            state.setRunState(RunState.Committed);
            return 0L;
        }
        Tx localState = this.journal.getLocalTransactionManager().getTx(state.tx);
        if (localState == null) {
            throw new AssertionError((Object)("Not in local tables: " + state));
        }
        localState.lock.lock();
        try {
            if (localState.isEmptyWriteSet()) {
                localState.setRunState(RunState.Committed);
                this.journal.getLocalTransactionManager().deactivateTx(localState);
                state.setRunState(RunState.Committed);
                long l = 0L;
                return l;
            }
        }
        finally {
            localState.lock.unlock();
        }
        ConcurrencyManager concurrencyManager = this.journal.getConcurrencyManager();
        SinglePhaseCommit task = new SinglePhaseCommit((IConcurrencyManager)concurrencyManager, this.journal.getLocalTransactionManager(), localState);
        try {
            concurrencyManager.submit(task).get();
            localState.lock.lock();
            try {
                localState.setRunState(RunState.Committed);
                this.journal.getLocalTransactionManager().deactivateTx(localState);
                state.setRunState(RunState.Committed);
            }
            finally {
                localState.lock.unlock();
            }
        }
        catch (Throwable t) {
            localState.lock.lock();
            try {
                localState.setRunState(RunState.Aborted);
                this.journal.getLocalTransactionManager().deactivateTx(localState);
                state.setRunState(RunState.Aborted);
                throw new RuntimeException(t);
            }
            catch (Throwable throwable) {
                localState.lock.unlock();
                throw throwable;
            }
        }
        return task.getCommitTime();
    }

    @Override
    public final long getLastCommitTime() {
        return this.journal.getRootBlockView().getLastCommitTime();
    }

    @Override
    public AbstractFederation<?> getFederation() {
        throw new UnsupportedOperationException();
    }

    public static class ValidateWriteSetTask
    extends AbstractTask<Boolean> {
        private final Tx state;

        public ValidateWriteSetTask(IConcurrencyManager concurrencyManager, ILocalTransactionManager localTransactionManager, Tx state) {
            super(concurrencyManager, 0L, state.getDirtyResource());
            if (localTransactionManager == null) {
                throw new IllegalArgumentException();
            }
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean doTask() throws Exception {
            this.state.lock.lockInterruptibly();
            try {
                Boolean bl = this.state.validateWriteSets();
                return bl;
            }
            finally {
                this.state.lock.unlock();
            }
        }
    }

    public static class SinglePhaseCommit
    extends AbstractTask<Void> {
        private final Tx state;
        private final ILocalTransactionManager localTransactionManager;

        public SinglePhaseCommit(IConcurrencyManager concurrencyManager, ILocalTransactionManager localTransactionManager, Tx state) {
            super(concurrencyManager, 0L, state.getDirtyResource());
            if (localTransactionManager == null) {
                throw new IllegalArgumentException();
            }
            this.localTransactionManager = localTransactionManager;
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void doTask() throws Exception {
            long revisionTime = this.localTransactionManager.nextTimestamp();
            this.state.lock.lockInterruptibly();
            try {
                this.state.prepare(revisionTime);
            }
            finally {
                this.state.lock.unlock();
            }
            return null;
        }
    }
}

