/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.gom.om;

import com.bigdata.gom.om.ObjectMgrModel;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.sail.Sesame2BigdataIterator;
import com.bigdata.rdf.sail.webapp.client.IPreparedGraphQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedTupleQuery;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.TupleQueryResult;

public class NanoSparqlObjectManager
extends ObjectMgrModel {
    private static final Logger log = Logger.getLogger(NanoSparqlObjectManager.class);
    private final RemoteRepository m_repo;

    public NanoSparqlObjectManager(RemoteRepository repo, String namespace) {
        super(repo.getSparqlEndPoint(), BigdataValueFactoryImpl.getInstance(namespace));
        this.m_repo = repo;
    }

    @Override
    public ICloseableIterator<BindingSet> evaluate(String query) {
        try {
            IPreparedTupleQuery q = this.m_repo.prepareTupleQuery(query);
            TupleQueryResult res = q.evaluate();
            return new Sesame2BigdataIterator(res);
        }
        catch (Exception ex) {
            throw new RuntimeException("query=" + query, ex);
        }
    }

    @Override
    public void execute(String updateStr) {
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public ICloseableIterator<Statement> evaluateGraph(String query) {
        try {
            IPreparedGraphQuery q = this.m_repo.prepareGraphQuery(query);
            GraphQueryResult res = q.evaluate();
            return new Sesame2BigdataIterator(res);
        }
        catch (Exception ex) {
            throw new RuntimeException("query=" + query, ex);
        }
    }

    @Override
    protected void flushStatements(List<Statement> m_inserts, List<Statement> m_removes) {
        try {
            RemoteRepository.AddOp iop;
            RemoteRepository.RemoveOp rop = m_removes.size() > 0 ? new RemoteRepository.RemoveOp(m_removes) : null;
            RemoteRepository.AddOp addOp = iop = m_inserts.size() > 0 ? new RemoteRepository.AddOp(m_inserts) : null;
            if (rop != null && iop != null) {
                this.m_repo.update(rop, iop);
            } else if (iop != null) {
                this.m_repo.add(iop);
            } else if (rop != null) {
                this.m_repo.remove(rop);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to flush statements", e);
        }
    }
}

