/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.concurrent;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NamedReadWriteLock<T> {
    private final Map<T, ReentrantReadWriteLock> locks = new WeakHashMap<T, ReentrantReadWriteLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReentrantReadWriteLock lockFactory(T name) {
        ReentrantReadWriteLock lock;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Map<T, ReentrantReadWriteLock> map = this.locks;
        synchronized (map) {
            lock = this.locks.get(name);
            if (lock == null) {
                lock = new ReentrantReadWriteLock();
                this.locks.put(name, lock);
            }
        }
        return lock;
    }

    public Lock acquireReadLock(T name) {
        ReentrantReadWriteLock.ReadLock lock = this.lockFactory(name).readLock();
        lock.lock();
        return lock;
    }

    public Lock acquireReadLock(T name, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ReentrantReadWriteLock.ReadLock lock = this.lockFactory(name).readLock();
        if (!lock.tryLock(timeout, unit)) {
            throw new TimeoutException();
        }
        return lock;
    }

    public Lock acquireWriteLock(T name) {
        ReentrantReadWriteLock.WriteLock lock = this.lockFactory(name).writeLock();
        lock.lock();
        return lock;
    }

    public Lock acquireWriteLock(T name, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ReentrantReadWriteLock.WriteLock lock = this.lockFactory(name).writeLock();
        if (!lock.tryLock(timeout, unit)) {
            throw new TimeoutException();
        }
        return lock;
    }
}

