/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.proc;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ILinearList;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.UnisolatedReadWriteIndex;
import com.bigdata.btree.proc.AbstractIndexProcedure;
import com.bigdata.btree.proc.IKeyArrayIndexProcedure;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.ReadOnlyKeysRaba;
import com.bigdata.btree.raba.ReadOnlyValuesRaba;
import com.bigdata.btree.raba.SubRangeRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.FixedByteArrayBuffer;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.IClientIndex;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public abstract class AbstractKeyArrayIndexProcedure<T>
extends AbstractIndexProcedure<T>
implements IKeyArrayIndexProcedure<T>,
Externalizable {
    private static final Logger log = Logger.getLogger(AbstractKeyArrayIndexProcedure.class);
    private static final transient int maxReaders = Integer.parseInt(System.getProperty(AbstractKeyArrayIndexProcedure.class.getName() + ".maxReaders", "0"));
    private static final transient int skipCount = Integer.parseInt(System.getProperty(AbstractKeyArrayIndexProcedure.class.getName() + ".skipCount", "256"));
    private static final transient int spannedRangeMultiplier = Integer.parseInt(System.getProperty(AbstractKeyArrayIndexProcedure.class.getName() + ".spannedRangeMultiplier", "10"));
    private static final transient int batchSize = Integer.parseInt(System.getProperty(AbstractKeyArrayIndexProcedure.class.getName() + ".batchSize", "10240"));
    private static final transient int queueCapacity = Integer.parseInt(System.getProperty(AbstractKeyArrayIndexProcedure.class.getName() + ".queueCapacity", "0"));
    private IRabaCoder keysCoder;
    private IRabaCoder valsCoder;
    private IRaba keys;
    private IRaba vals;
    private static final byte VERSION0 = 0;

    protected IRabaCoder getKeysCoder() {
        return this.keysCoder;
    }

    protected IRabaCoder getValuesCoder() {
        return this.valsCoder;
    }

    @Override
    public final IRaba getKeys() {
        return this.keys;
    }

    @Override
    public final IRaba getValues() {
        return this.vals;
    }

    protected abstract IResultHandler<T, T> newAggregator();

    protected AbstractKeyArrayIndexProcedure() {
    }

    protected AbstractKeyArrayIndexProcedure(IRabaCoder keysCoder, IRabaCoder valsCoder, int fromIndex, int toIndex, byte[][] keys, byte[][] vals) {
        if (keysCoder == null) {
            throw new IllegalArgumentException();
        }
        if (valsCoder == null && vals != null) {
            throw new IllegalArgumentException();
        }
        if (keys == null) {
            throw new IllegalArgumentException("keys is null");
        }
        if (fromIndex < 0) {
            throw new IllegalArgumentException("fromIndex is invalid");
        }
        if (fromIndex >= toIndex) {
            throw new IllegalArgumentException("fromIndex is invalid");
        }
        if (toIndex > keys.length) {
            throw new IllegalArgumentException("toIndex is invalid");
        }
        if (vals != null && toIndex > vals.length) {
            throw new IllegalArgumentException("toIndex is invalid");
        }
        this.keysCoder = keysCoder;
        this.valsCoder = valsCoder;
        this.keys = new ReadOnlyKeysRaba(fromIndex, toIndex, keys);
        this.vals = vals == null ? null : new ReadOnlyValuesRaba(fromIndex, toIndex, vals);
    }

    @Override
    public final T apply(IIndex ndx) {
        IRawStore store;
        boolean isFusedView;
        if (ndx instanceof IClientIndex) {
            throw new UnsupportedOperationException();
        }
        boolean smallBatch = false;
        if (maxReaders <= 0 || !(this instanceof IParallelizableIndexProcedure)) {
            return this.applyOnce(ndx, this.keys, this.vals);
        }
        IResultHandler<T, T> resultHandler = this.newAggregator();
        if (resultHandler == null) {
            return this.applyOnce(ndx, this.keys, this.vals);
        }
        boolean bl = isFusedView = ndx instanceof ILocalBTreeView && ((ILocalBTreeView)ndx).getSourceCount() > 1;
        if (isFusedView && !this.isReadOnly()) {
            return this.applyOnce(ndx, this.keys, this.vals);
        }
        if (ndx instanceof ILocalBTreeView) {
            store = ((ILocalBTreeView)ndx).getMutableBTree().getStore();
        } else if (ndx instanceof UnisolatedReadWriteIndex) {
            store = ((UnisolatedReadWriteIndex)ndx).getStore();
        } else {
            throw new AssertionError((Object)("Can't get backing store for " + ndx.getClass().getName()));
        }
        if (!(store instanceof IIndexManager)) {
            return this.applyOnce(ndx, this.keys, this.vals);
        }
        ExecutorService executorService = ((IIndexManager)((Object)store)).getExecutorService();
        try {
            if (this.isReadOnly()) {
                return this.applyMultipleReadersNoWriter(executorService, ndx, resultHandler);
            }
            return this.applyMultipleReadersOneWriter(executorService, ndx, false, resultHandler);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    private T applyMultipleReadersNoWriter(ExecutorService executorService, IIndex ndx, IResultHandler<T, T> resultHandler) throws InterruptedException, ExecutionException {
        int keysSize = this.keys.size();
        Stats stats = new Stats();
        LinkedList<ReadOnlyTask> readerTasks = new LinkedList<ReadOnlyTask>();
        int readerSize = Math.max(batchSize, (int)Math.ceil((double)keysSize / (double)maxReaders));
        int fromIndex = 0;
        int toIndex = -1;
        boolean done = false;
        while (!done) {
            toIndex = fromIndex + readerSize;
            if (toIndex > keysSize) {
                toIndex = keysSize;
                done = true;
            }
            readerTasks.add(new ReadOnlyTask(ndx, resultHandler, stats, new Batch(fromIndex, toIndex, this.keys, this.vals)));
            fromIndex = toIndex;
        }
        stats.readerBatchCount.set(readerTasks.size());
        List readerFutures = executorService.invokeAll(readerTasks);
        for (Future f : readerFutures) {
            f.get();
        }
        log.fatal((Object)("maxReaders=" + maxReaders + ", skipCount=" + skipCount + ", spannedRangeMultiplier=" + spannedRangeMultiplier + ", batchSize=" + batchSize + ", queueCapacity=" + queueCapacity + ", nkeys=" + keysSize + ", nreaders=" + stats.readerBatchCount + ", proc=" + this.getClass().getSimpleName()));
        return resultHandler.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T applyMultipleReadersOneWriter(ExecutorService executorService, IIndex ndx, boolean readOnly, IResultHandler<T, T> resultHandler) throws InterruptedException, ExecutionException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        int keysSize = this.keys.size();
        int effectiveQueueCapacity = queueCapacity <= 0 ? maxReaders * 2 : queueCapacity;
        LinkedBlockingQueue<Batch> queue = new LinkedBlockingQueue<Batch>(effectiveQueueCapacity);
        Stats stats = new Stats();
        FutureTask writerFuture = new FutureTask(new WriterTask(lock, queue, ndx, resultHandler, stats));
        LinkedList readerTasks = new LinkedList();
        int readerSize = Math.max(batchSize, (int)Math.ceil((double)keysSize / (double)maxReaders));
        int fromIndex = 0;
        int toIndex = -1;
        boolean done = false;
        while (!done) {
            toIndex = fromIndex + readerSize;
            if (toIndex > keysSize) {
                toIndex = keysSize;
                done = true;
            }
            readerTasks.add(new ReaderTask(readOnly, lock, queue, writerFuture, ndx, new Batch(fromIndex, toIndex, this.keys, this.vals)));
            fromIndex = toIndex;
        }
        stats.readerBatchCount.set(readerTasks.size());
        try {
            executorService.submit(writerFuture);
            List readerFutures = executorService.invokeAll(readerTasks);
            AbstractKeyArrayIndexProcedure.putOnQueue(writerFuture, queue, Batch.POISON_PILL);
            for (Future f : readerFutures) {
                f.get();
            }
            Object ret = writerFuture.get();
            log.fatal((Object)("maxReaders=" + maxReaders + ", skipCount=" + skipCount + ", spannedRangeMultiplier=" + spannedRangeMultiplier + ", batchSize=" + batchSize + ", queueCapacity=" + queueCapacity + ", nkeys=" + keysSize + ", nreaders=" + stats.readerBatchCount + ", writerBatches=" + stats.writerBatchCount + ", keys/writeBatch=" + (long)keysSize / stats.writerBatchCount.get() + ", proc=" + this.getClass().getSimpleName()));
            Object v = ret;
            return (T)v;
        }
        finally {
            writerFuture.cancel(true);
        }
    }

    private static void putOnQueue(Future<?> writerFuture, LinkedBlockingQueue<Batch> queue, Batch batch) throws InterruptedException {
        while (!writerFuture.isDone()) {
            if (!queue.offer(batch, 100L, TimeUnit.MILLISECONDS)) continue;
            return;
        }
        if (writerFuture.isDone()) {
            throw new RuntimeException("Writer is done, but reader still working?");
        }
    }

    protected abstract T applyOnce(IIndex var1, IRaba var2, IRaba var3);

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readMetadata(in);
        boolean haveVals = in.readBoolean();
        int len = in.readInt();
        byte[] a = new byte[len];
        in.readFully(a);
        this.keys = this.keysCoder.decode(FixedByteArrayBuffer.wrap(a));
        if (haveVals) {
            len = in.readInt();
            a = new byte[len];
            in.readFully(a);
            this.vals = this.valsCoder.decode(FixedByteArrayBuffer.wrap(a));
        } else {
            this.vals = null;
        }
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        this.writeMetadata(out);
        out.writeBoolean(this.vals != null);
        DataOutputBuffer buf = new DataOutputBuffer();
        AbstractFixedByteArrayBuffer slice = this.keysCoder.encode(this.keys, buf);
        out.writeInt(slice.len());
        slice.writeOn(out);
        if (this.vals != null) {
            buf.reset();
            slice = this.valsCoder.encode(this.vals, buf);
            out.writeInt(slice.len());
            slice.writeOn(out);
        }
    }

    protected void readMetadata(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new IOException();
            }
        }
        this.keysCoder = (IRabaCoder)in.readObject();
        this.valsCoder = (IRabaCoder)in.readObject();
    }

    protected void writeMetadata(ObjectOutput out) throws IOException {
        out.write(0);
        out.writeObject(this.keysCoder);
        out.writeObject(this.valsCoder);
    }

    public static class ResultBitBufferCounter
    implements IResultHandler<ResultBitBuffer, Long> {
        private final AtomicLong ntrue = new AtomicLong();

        @Override
        public void aggregate(ResultBitBuffer result, Split split) {
            int delta = 0;
            for (int i = 0; i < result.n; ++i) {
                if (!result.a[i]) continue;
                ++delta;
            }
            this.ntrue.addAndGet(delta);
        }

        @Override
        public Long getResult() {
            return this.ntrue.get();
        }
    }

    public static class ResultBitBufferHandler
    implements IResultHandler<ResultBitBuffer, ResultBitBuffer> {
        private final boolean[] results;
        private final int multiplier;
        private final AtomicInteger onCount = new AtomicInteger();

        public ResultBitBufferHandler(int nkeys) {
            this(nkeys, 1);
        }

        public ResultBitBufferHandler(int nkeys, int multiplier) {
            this.results = new boolean[nkeys * multiplier];
            this.multiplier = multiplier;
        }

        @Override
        public void aggregate(ResultBitBuffer result, Split split) {
            System.arraycopy(result.getResult(), 0, this.results, split.fromIndex * this.multiplier, split.ntuples * this.multiplier);
            this.onCount.addAndGet(result.getOnCount());
        }

        @Override
        public ResultBitBuffer getResult() {
            return new ResultBitBuffer(this.results.length, this.results, this.onCount.get());
        }
    }

    public static class ResultBufferHandler
    implements IResultHandler<ResultBuffer, ResultBuffer> {
        private final byte[][] results;
        private final IRabaCoder valsCoder;

        public ResultBufferHandler(int nkeys, IRabaCoder valsCoder) {
            this.results = new byte[nkeys][];
            this.valsCoder = valsCoder;
        }

        @Override
        public void aggregate(ResultBuffer result, Split split) {
            IRaba src = result.getValues();
            int i = 0;
            int j = split.fromIndex;
            while (i < split.ntuples) {
                this.results[j] = src.get(i);
                ++i;
                ++j;
            }
        }

        @Override
        public ResultBuffer getResult() {
            return new ResultBuffer(this.results.length, this.results, this.valsCoder);
        }
    }

    public static class ResultBitBuffer
    implements Externalizable {
        private static final long serialVersionUID = 1918403771057371471L;
        private int n;
        private boolean[] a;
        private transient int onCount;
        private static final transient byte VERSION0 = 0;
        private static final transient byte VERSION = 0;

        public ResultBitBuffer() {
        }

        public ResultBitBuffer(int n, boolean[] a, int onCount) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (a == null) {
                throw new IllegalArgumentException();
            }
            if (onCount < 0 || onCount > n) {
                throw new IllegalArgumentException();
            }
            this.n = n;
            this.a = a;
            this.onCount = onCount;
        }

        public int getResultCount() {
            return this.n;
        }

        public boolean[] getResult() {
            return this.a;
        }

        public int getOnCount() {
            return this.onCount;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown version: " + version);
                }
            }
            InputBitStream ibs = new InputBitStream((InputStream)((Object)in), 0, false);
            this.n = ibs.readNibble();
            this.a = new boolean[this.n];
            for (int i = 0; i < this.n; ++i) {
                boolean bit = ibs.readBit() == 1;
                this.a[i] = bit;
                if (!this.a[i]) continue;
                ++this.onCount;
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(0);
            OutputBitStream obs = new OutputBitStream((OutputStream)((Object)out), 0, false);
            obs.writeNibble(this.n);
            for (int i = 0; i < this.n; ++i) {
                obs.writeBit(this.a[i]);
            }
            obs.flush();
        }
    }

    public static class ResultBuffer
    implements Externalizable {
        private static final long serialVersionUID = 3545214696708412869L;
        private IRaba vals;
        private IRabaCoder valsCoder;
        private static final byte VERSION0 = 0;

        public ResultBuffer() {
        }

        public ResultBuffer(int n, byte[][] a, IRabaCoder valsCoder) {
            assert (n >= 0);
            assert (a != null);
            assert (valsCoder != null);
            this.vals = new ReadOnlyValuesRaba(0, n, a);
            this.valsCoder = valsCoder;
        }

        public IRaba getValues() {
            return this.vals;
        }

        public int getResultCount() {
            return this.vals.size();
        }

        public byte[] getResult(int index) {
            return this.vals.get(index);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            this.valsCoder = (IRabaCoder)in.readObject();
            int len = in.readInt();
            byte[] b = new byte[len];
            in.readFully(b);
            this.vals = this.valsCoder.decode(FixedByteArrayBuffer.wrap(b));
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(0);
            out.writeObject(this.valsCoder);
            AbstractFixedByteArrayBuffer slice = this.valsCoder.encode(this.vals, new DataOutputBuffer());
            out.writeInt(slice.len());
            slice.writeOn(out);
        }
    }

    private static class ReaderTask<T>
    implements Callable<Void> {
        private final boolean readOnly;
        private final ReentrantReadWriteLock lock;
        private final LinkedBlockingQueue<Batch> queue;
        private final Future<T> writerFuture;
        private final IIndex view;
        private final Batch batch;

        ReaderTask(boolean readOnly, ReentrantReadWriteLock lock, LinkedBlockingQueue<Batch> queue, Future<T> writerFuture, IIndex view, Batch batch) {
            if (lock == null) {
                throw new IllegalArgumentException();
            }
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            if (writerFuture == null) {
                throw new IllegalArgumentException();
            }
            if (view == null) {
                throw new IllegalArgumentException();
            }
            if (batch == null) {
                throw new IllegalArgumentException();
            }
            this.readOnly = readOnly;
            this.lock = lock;
            this.queue = queue;
            this.writerFuture = writerFuture;
            this.view = view;
            this.batch = batch;
        }

        @Override
        public Void call() throws Exception {
            if (this.view instanceof UnisolatedReadWriteIndex || this.view instanceof ILocalBTreeView && ((ILocalBTreeView)this.view).getSourceCount() == 1) {
                if (!(this.view instanceof ILinearList)) {
                    throw new AssertionError((Object)("Unexpected index type: " + this.view.getClass().getName() + " does not implement " + ILinearList.class.getName()));
                }
                this.doSimpleBTree(this.lock, this.view, this.batch, this.queue);
            } else if (this.view instanceof ILocalBTreeView) {
                ReaderTask.doFusedView((ILocalBTreeView)this.view, this.batch, this.queue);
            } else {
                throw new AssertionError((Object)("Unexpected index type: " + this.view.getClass().getName()));
            }
            return null;
        }

        private static void doFusedView(ILocalBTreeView view, Batch batch, LinkedBlockingQueue<Batch> queue) {
            if (view == null) {
                throw new IllegalArgumentException();
            }
            if (batch == null) {
                throw new IllegalArgumentException();
            }
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doSimpleBTree(ReentrantReadWriteLock lock, IIndex ndx, Batch batch, LinkedBlockingQueue<Batch> queue) throws InterruptedException {
            int firstRabaIndex;
            int currentRabaIndex;
            if (lock == null) {
                throw new IllegalArgumentException();
            }
            if (ndx == null) {
                throw new IllegalArgumentException();
            }
            if (!(ndx instanceof UnisolatedReadWriteIndex) && !(ndx instanceof AbstractBTree)) {
                throw new IllegalArgumentException("Index may be either: " + UnisolatedReadWriteIndex.class.getName() + " or " + AbstractBTree.class.getName() + ", but have " + ndx.getClass().getName());
            }
            if (batch == null) {
                throw new IllegalArgumentException();
            }
            int branchingFactor = ndx.getIndexMetadata().getBranchingFactor();
            long evictRange = branchingFactor * (spannedRangeMultiplier == 0 ? branchingFactor : spannedRangeMultiplier);
            long firstIndex = -1L;
            for (currentRabaIndex = firstRabaIndex = batch.fromIndex; currentRabaIndex < batch.toIndex; currentRabaIndex += skipCount) {
                long indexOf;
                byte[] currentKey = batch.keys.get(currentRabaIndex);
                lock.readLock().lock();
                try {
                    if (this.writerFuture.isDone()) {
                        throw new RuntimeException("Writer is dead?");
                    }
                    long n = ((ILinearList)((Object)ndx)).indexOf(currentKey);
                    if (n < 0L) {
                        n = -(n + 1L);
                    }
                    indexOf = n;
                }
                finally {
                    lock.readLock().unlock();
                }
                if (firstIndex == -1L) {
                    firstIndex = indexOf;
                }
                long spannedRange = indexOf - firstIndex;
                assert (spannedRange >= 0L);
                if (spannedRange < evictRange) continue;
                this.putOnQueue(new Batch(firstRabaIndex, currentRabaIndex, batch.keys, batch.vals));
                firstRabaIndex = currentRabaIndex;
            }
            if (currentRabaIndex - firstRabaIndex > 0) {
                this.putOnQueue(new Batch(firstRabaIndex, batch.toIndex, batch.keys, batch.vals));
            }
        }

        private void putOnQueue(Batch batch) throws InterruptedException {
            AbstractKeyArrayIndexProcedure.putOnQueue(this.writerFuture, this.queue, batch);
        }
    }

    private class WriterTask
    implements Callable<T> {
        private final ReentrantReadWriteLock lock;
        private final IIndex ndx;
        private final LinkedBlockingQueue<Batch> queue;
        private final IResultHandler<T, T> resultHandler;
        private final Stats stats;

        WriterTask(ReentrantReadWriteLock lock, LinkedBlockingQueue<Batch> queue, IIndex view, IResultHandler<T, T> resultHandler, Stats stats) {
            if (lock == null) {
                throw new IllegalArgumentException();
            }
            if (view == null) {
                throw new IllegalArgumentException();
            }
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            if (resultHandler == null) {
                throw new IllegalArgumentException();
            }
            if (stats == null) {
                throw new IllegalArgumentException();
            }
            this.lock = lock;
            this.queue = queue;
            this.ndx = view;
            this.resultHandler = resultHandler;
            this.stats = stats;
            if (AbstractKeyArrayIndexProcedure.this.isReadOnly()) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            Batch batch;
            while ((batch = this.queue.take()) != Batch.POISON_PILL) {
                Object aResult;
                if (batch.ntuples == 0) {
                    throw new AssertionError((Object)"Empty batch");
                }
                SubRangeRaba keysView = new SubRangeRaba(batch.keys, batch.fromIndex, batch.toIndex);
                SubRangeRaba valsView = batch.vals == null ? null : new SubRangeRaba(batch.vals, batch.fromIndex, batch.toIndex);
                this.lock.writeLock().lock();
                try {
                    aResult = AbstractKeyArrayIndexProcedure.this.applyOnce(this.ndx, keysView, valsView);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                this.resultHandler.aggregate(aResult, batch);
                this.stats.writerBatchCount.incrementAndGet();
            }
            return this.resultHandler.getResult();
        }
    }

    private static class Batch
    extends Split {
        private final IRaba keys;
        private final IRaba vals;
        private static final Batch POISON_PILL = new Batch();

        Batch(int fromIndex, int toIndex, IRaba keys, IRaba vals) {
            super(null, fromIndex, toIndex);
            this.keys = keys;
            this.vals = vals;
        }

        private Batch() {
            super(null, 0, 0);
            this.vals = null;
            this.keys = null;
        }
    }

    private class ReadOnlyTask
    implements Callable<Void> {
        private final IIndex view;
        private final Batch batch;
        private final IResultHandler<T, T> resultHandler;
        private final Stats stats;

        ReadOnlyTask(IIndex view, IResultHandler<T, T> resultHandler, Stats stats, Batch batch) {
            if (view == null) {
                throw new IllegalArgumentException();
            }
            if (batch == null) {
                throw new IllegalArgumentException();
            }
            if (resultHandler == null) {
                throw new IllegalArgumentException();
            }
            if (stats == null) {
                throw new IllegalArgumentException();
            }
            this.view = view;
            this.batch = batch;
            this.resultHandler = resultHandler;
            this.stats = stats;
        }

        @Override
        public Void call() throws Exception {
            SubRangeRaba keysView = new SubRangeRaba(this.batch.keys, this.batch.fromIndex, this.batch.toIndex);
            SubRangeRaba valsView = this.batch.vals == null ? null : new SubRangeRaba(this.batch.vals, this.batch.fromIndex, this.batch.toIndex);
            Object aResult = AbstractKeyArrayIndexProcedure.this.applyOnce(this.view, keysView, valsView);
            this.resultHandler.aggregate(aResult, this.batch);
            return null;
        }
    }

    private static class Stats {
        private final AtomicLong readerBatchCount = new AtomicLong();
        private final AtomicLong writerBatchCount = new AtomicLong();

        private Stats() {
        }
    }
}

