/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.ISingleThreadedOp;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.join.HTreeHashJoinAnnotations;
import com.bigdata.bop.join.HTreeHashJoinUtility;
import com.bigdata.bop.join.HashJoinOp;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.bop.join.JoinTypeEnum;
import java.util.Map;

public class HTreeHashJoinOp<E>
extends HashJoinOp<E>
implements ISingleThreadedOp {
    private static final long serialVersionUID = 1L;

    public HTreeHashJoinOp(HTreeHashJoinOp<E> op) {
        super(op);
    }

    public HTreeHashJoinOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    public HTreeHashJoinOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        this.assertMaxParallelOne();
        if (!this.isLastPassRequested()) {
            throw new IllegalArgumentException(PipelineOp.Annotations.LAST_PASS + "=" + this.isLastPassRequested());
        }
        if (this.getMaxMemory() <= 0L) {
            throw new UnsupportedOperationException(Annotations.MAX_MEMORY + "=" + this.getMaxMemory());
        }
        if (this.isOptional() && this.getMaxMemory() != Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Optional join, but " + PipelineOp.Annotations.MAX_MEMORY + " is constrained");
        }
    }

    @Override
    protected IHashJoinUtility newState(BOpContext<IBindingSet> context, INamedSolutionSetRef namedSetRef, JoinTypeEnum joinType) {
        return new HTreeHashJoinUtility(context.getRunningQuery().getMemoryManager(), this, joinType);
    }

    @Override
    protected boolean runHashJoin(BOpContext<?> context, IHashJoinUtility state) {
        long maxMemory = this.getMaxMemory();
        long usedMemory = ((HTreeHashJoinUtility)state).getStore().size();
        return context.isLastInvocation() || usedMemory >= maxMemory;
    }

    public static interface Annotations
    extends HashJoinOp.Annotations,
    HTreeHashJoinAnnotations {
    }
}

