/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.rawstore.IBlock;
import java.io.IOException;
import java.io.InputStream;

public class FileVersionInputStream
extends InputStream {
    protected final String id;
    protected final int version;
    private final ITupleIterator src;
    private long block;
    private byte[] b;
    private int off;
    private int len;

    public String getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public long getBlock() {
        return this.block;
    }

    public FileVersionInputStream(String id, int version, ITupleIterator src) {
        this.id = id;
        this.version = version;
        this.src = src;
        this.nextBlock();
    }

    private boolean nextBlock() {
        long addr;
        assert (this.b == null || this.off == this.len);
        if (!this.src.hasNext()) {
            BigdataFileSystem.log.info((Object)("No more blocks: id=" + this.id + ", version=" + this.version));
            this.b = null;
            this.off = 0;
            this.len = 0;
            return false;
        }
        ITuple tuple = this.src.next();
        try {
            DataInputBuffer in = tuple.getValueStream();
            addr = in.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (addr == 0L) {
            this.b = new byte[0];
            this.off = 0;
            this.len = 0;
            BigdataFileSystem.log.info((Object)("Read zero bytes: id=" + this.id + ", version=" + this.version + ", block=" + this.block));
        } else {
            byte[] key = tuple.getKey();
            this.block = KeyBuilder.decodeLong(key, key.length - 8);
            IBlock tmp = tuple.readBlock(addr);
            int nbytes = tmp.length();
            this.b = new byte[nbytes];
            this.off = 0;
            this.len = nbytes;
            try {
                int nread = tmp.inputStream().read(this.b, this.off, this.len);
                if (nread != this.len) {
                    throw new RuntimeException("Expecting " + this.len + " bytes but read " + nread);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            BigdataFileSystem.log.info((Object)("Read " + this.b.length + " bytes: id=" + this.id + ", version=" + this.version + ", block=" + this.block));
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.b == null) {
            return -1;
        }
        if (this.off == this.len && !this.nextBlock()) {
            return -1;
        }
        int v = 0xFF & this.b[this.off++];
        return v;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            return -1;
        }
        if (this.off == this.len && !this.nextBlock()) {
            return -1;
        }
        int n = Math.min(this.len, len);
        System.arraycopy(this.b, this.off, b, off, n);
        this.off += n;
        return n;
    }
}

