"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualRouterListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * Represents the properties needed to define listeners for a VirtualRouter
 */
class VirtualRouterListener {
    /**
     * Returns an HTTP Listener for a VirtualRouter
     *
     * @param port the optional port of the listener, 8080 by default
     */
    static http(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.HTTP, port);
    }
    /**
     * Returns an HTTP2 Listener for a VirtualRouter
     *
     * @param port the optional port of the listener, 8080 by default
     */
    static http2(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.HTTP2, port);
    }
    /**
     * Returns a GRPC Listener for a VirtualRouter
     *
     * @param port the optional port of the listener, 8080 by default
     */
    static grpc(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.GRPC, port);
    }
    /**
     * Returns a TCP Listener for a VirtualRouter
     *
     * @param port the optional port of the listener, 8080 by default
     */
    static tcp(port) {
        return new VirtualRouterListenerImpl(shared_interfaces_1.Protocol.TCP, port);
    }
}
exports.VirtualRouterListener = VirtualRouterListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualRouterListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualRouterListener", version: "1.180.0" };
class VirtualRouterListenerImpl extends VirtualRouterListener {
    constructor(protocol, port) {
        super();
        this.protocol = protocol;
        this.port = port ?? 8080;
    }
    bind(_scope) {
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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