"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkCloudwatchAutoRetention = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
/**
 * @stability stable
 */
class CdkCloudwatchAutoRetention extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        var _b;
        super(scope, id);
        // Create Lambda function
        const handler = new aws_lambda_1.Function(this, 'LambdaCloudwatchAutoRetention', {
            handler: 'run.handler',
            code: aws_lambda_1.Code.fromAsset('functions'),
            runtime: aws_lambda_1.Runtime.PYTHON_3_9,
            architecture: aws_lambda_1.Architecture.ARM_64,
            description: 'Lambda that gets triggered the first of the month. Checks all Cloudwatch log groups and changes those with never-expire to one month.',
        });
        // Set task role and permissions
        const cloudwatchListSetRetention = new aws_iam_1.PolicyStatement({
            actions: [
                'logs:DescribeLogGroups',
                'logs:PutRetentionPolicy',
            ],
            resources: ['arn:aws:logs:*:*:log-group:*'],
        });
        (_b = handler.role) === null || _b === void 0 ? void 0 : _b.attachInlinePolicy(new aws_iam_1.Policy(this, 'cloudwatch-list-set-retention', {
            statements: [cloudwatchListSetRetention],
        }));
        // Run this script once a month on the first of the month
        const rule = new aws_events_1.Rule(this, 'ScheduleCloudwatchAutoRetention', {
            schedule: aws_events_1.Schedule.cron({ minute: '0', hour: '1', day: '1' }),
        });
        rule.addTarget(new aws_events_targets_1.LambdaFunction(handler));
    }
}
exports.CdkCloudwatchAutoRetention = CdkCloudwatchAutoRetention;
_a = JSII_RTTI_SYMBOL_1;
CdkCloudwatchAutoRetention[_a] = { fqn: "cloudwatch-auto-retention.CdkCloudwatchAutoRetention", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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