from typing import Any, Dict, List, Type, TypeVar

import attr

T = TypeVar("T", bound="EnumBundleElement")


try:
    from ..models import localizable_bundle_element
except ImportError:
    import sys

    localizable_bundle_element = sys.modules[__package__ + "localizable_bundle_element"]


@attr.s(auto_attribs=True)
class EnumBundleElement(localizable_bundle_element.LocalizableBundleElement):
    """Represents an enumeration value in YouTrack."""

    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:

        field_dict: Dict[str, Any] = {}
        _LocalizableBundleElement_dict = super().to_dict()
        field_dict.update(_LocalizableBundleElement_dict)
        field_dict.update(self.additional_properties)
        field_dict.update({})

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:

        d = src_dict.copy()

        enum_bundle_element = cls()

        enum_bundle_element.additional_properties = d
        return enum_bundle_element

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
