from typing import Any, Dict, List, Optional, Union

import httpx

from ...client import Client
from ...models import activity_item as activity_item_m
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    client: Client,
    categories: "Union[Unset, None, str]" = UNSET,
    reverse: "Union[Unset, None, bool]" = UNSET,
    start: "Union[Unset, None, str]" = UNSET,
    end: "Union[Unset, None, str]" = UNSET,
    author: "Union[Unset, None, str]" = UNSET,
    issue_query: "Union[Unset, None, str]" = UNSET,
    fields: "Union[Unset, None, str]" = "$type,added,author($type,id,login,name,ringId),category($type,id),field($type,customField($type,fieldType($type,id),id,localizedName,name),id,name),id,removed,target,targetMember,timestamp",
    skip: "Union[Unset, None, int]" = UNSET,
    top: "Union[Unset, None, int]" = UNSET,
) -> Dict[str, Any]:
    url = "{}/activities".format(client.youtrack_base_url)

    headers: Dict[str, Any] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    params: Dict[str, Any] = {
        "categories": categories,
        "reverse": reverse,
        "start": start,
        "end": end,
        "author": author,
        "issueQuery": issue_query,
        "fields": fields,
        "$skip": skip,
        "$top": top,
    }
    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    return {
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
        "params": params,
    }


def _parse_response(*, response: httpx.Response) -> Optional[List[activity_item_m.ActivityItem]]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = activity_item_m.ActivityItem.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200
    return None


def _build_response(*, response: httpx.Response) -> Response[List[activity_item_m.ActivityItem]]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    *,
    client: Client,
    categories: "Union[Unset, None, str]" = UNSET,
    reverse: "Union[Unset, None, bool]" = UNSET,
    start: "Union[Unset, None, str]" = UNSET,
    end: "Union[Unset, None, str]" = UNSET,
    author: "Union[Unset, None, str]" = UNSET,
    issue_query: "Union[Unset, None, str]" = UNSET,
    fields: "Union[Unset, None, str]" = "$type,added,author($type,id,login,name,ringId),category($type,id),field($type,customField($type,fieldType($type,id),id,localizedName,name),id,name),id,removed,target,targetMember,timestamp",
    skip: "Union[Unset, None, int]" = UNSET,
    top: "Union[Unset, None, int]" = UNSET,
) -> Response[List[activity_item_m.ActivityItem]]:
    kwargs = _get_kwargs(
        client=client,
        categories=categories,
        reverse=reverse,
        start=start,
        end=end,
        author=author,
        issue_query=issue_query,
        fields=fields,
        skip=skip,
        top=top,
    )

    response = httpx.get(
        **kwargs,
    )

    return _build_response(response=response)


def sync(
    *,
    client: Client,
    categories: "Union[Unset, None, str]" = UNSET,
    reverse: "Union[Unset, None, bool]" = UNSET,
    start: "Union[Unset, None, str]" = UNSET,
    end: "Union[Unset, None, str]" = UNSET,
    author: "Union[Unset, None, str]" = UNSET,
    issue_query: "Union[Unset, None, str]" = UNSET,
    fields: "Union[Unset, None, str]" = "$type,added,author($type,id,login,name,ringId),category($type,id),field($type,customField($type,fieldType($type,id),id,localizedName,name),id,name),id,removed,target,targetMember,timestamp",
    skip: "Union[Unset, None, int]" = UNSET,
    top: "Union[Unset, None, int]" = UNSET,
) -> Optional[List[activity_item_m.ActivityItem]]:
    """ """

    return sync_detailed(
        client=client,
        categories=categories,
        reverse=reverse,
        start=start,
        end=end,
        author=author,
        issue_query=issue_query,
        fields=fields,
        skip=skip,
        top=top,
    ).parsed


async def asyncio_detailed(
    *,
    client: Client,
    categories: "Union[Unset, None, str]" = UNSET,
    reverse: "Union[Unset, None, bool]" = UNSET,
    start: "Union[Unset, None, str]" = UNSET,
    end: "Union[Unset, None, str]" = UNSET,
    author: "Union[Unset, None, str]" = UNSET,
    issue_query: "Union[Unset, None, str]" = UNSET,
    fields: "Union[Unset, None, str]" = "$type,added,author($type,id,login,name,ringId),category($type,id),field($type,customField($type,fieldType($type,id),id,localizedName,name),id,name),id,removed,target,targetMember,timestamp",
    skip: "Union[Unset, None, int]" = UNSET,
    top: "Union[Unset, None, int]" = UNSET,
) -> Response[List[activity_item_m.ActivityItem]]:
    kwargs = _get_kwargs(
        client=client,
        categories=categories,
        reverse=reverse,
        start=start,
        end=end,
        author=author,
        issue_query=issue_query,
        fields=fields,
        skip=skip,
        top=top,
    )

    async with httpx.AsyncClient() as _client:
        response = await _client.get(**kwargs)

    return _build_response(response=response)


async def asyncio(
    *,
    client: Client,
    categories: "Union[Unset, None, str]" = UNSET,
    reverse: "Union[Unset, None, bool]" = UNSET,
    start: "Union[Unset, None, str]" = UNSET,
    end: "Union[Unset, None, str]" = UNSET,
    author: "Union[Unset, None, str]" = UNSET,
    issue_query: "Union[Unset, None, str]" = UNSET,
    fields: "Union[Unset, None, str]" = "$type,added,author($type,id,login,name,ringId),category($type,id),field($type,customField($type,fieldType($type,id),id,localizedName,name),id,name),id,removed,target,targetMember,timestamp",
    skip: "Union[Unset, None, int]" = UNSET,
    top: "Union[Unset, None, int]" = UNSET,
) -> Optional[List[activity_item_m.ActivityItem]]:
    """ """

    return (
        await asyncio_detailed(
            client=client,
            categories=categories,
            reverse=reverse,
            start=start,
            end=end,
            author=author,
            issue_query=issue_query,
            fields=fields,
            skip=skip,
            top=top,
        )
    ).parsed
