"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool-client-explicit-props');
const userpool = new lib_1.UserPool(stack, 'myuserpool');
userpool.addClient('myuserpoolclient', {
    userPoolClientName: 'myuserpoolclient',
    authFlows: {
        adminUserPassword: true,
        custom: true,
        refreshToken: true,
        userPassword: true,
        userSrp: true,
    },
    generateSecret: true,
    oAuth: {
        flows: {
            implicitCodeGrant: true,
            authorizationCodeGrant: true,
        },
        scopes: [
            lib_1.OAuthScope.PHONE,
            lib_1.OAuthScope.EMAIL,
            lib_1.OAuthScope.OPENID,
            lib_1.OAuthScope.PROFILE,
            lib_1.OAuthScope.COGNITO_ADMIN,
        ],
        callbackUrls: ['https://redirect-here.myapp.com'],
    },
    preventUserExistenceErrors: true,
});
//# sourceMappingURL=data:application/json;base64,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