/**
 * Django Image Uploader Widget - An image uploader widget for django.
 * @version v0.1.3
 * @author Eduardo Oliveira (EduardoJM) <eduardo_y05@outlook.com>.
 * @link https://github.com/inventare/django-image-uploader-widget
 * 
 * Licensed under the MIT License (https://github.com/inventare/django-image-uploader-widget/blob/main/LICENSE).
 */

"use strict";function _classCallCheck(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function _defineProperties(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}function _createClass(e,t,i){return t&&_defineProperties(e.prototype,t),i&&_defineProperties(e,i),Object.defineProperty(e,"prototype",{writable:!1}),e}function _defineProperty(e,t,i){return t in e?Object.defineProperty(e,t,{value:i,enumerable:!0,configurable:!0,writable:!0}):e[t]=i,e}var ImageUploaderWidget=function(){function n(e){var r=this;_classCallCheck(this,n),_defineProperty(this,"element",void 0),_defineProperty(this,"fileInput",void 0),_defineProperty(this,"checkboxInput",void 0),_defineProperty(this,"emptyMarker",void 0),_defineProperty(this,"canDelete",!1),_defineProperty(this,"dragging",!1),_defineProperty(this,"canPreview",!0),_defineProperty(this,"raw",null),_defineProperty(this,"file",null),_defineProperty(this,"onEmptyMarkerClick",function(){r.fileInput.click()}),_defineProperty(this,"onDrop",function(e){var t;e.preventDefault(),r.dragging=!1,r.element.classList.remove("drop-zone"),null!==(t=e.dataTransfer)&&void 0!==t&&t.files.length&&(r.fileInput.files=e.dataTransfer.files,r.file=r.fileInput.files[0],r.raw=null,r.renderWidget())}),_defineProperty(this,"onDragEnter",function(){r.dragging=!0,r.element.classList.add("drop-zone")}),_defineProperty(this,"onDragOver",function(e){e&&e.preventDefault()}),_defineProperty(this,"onDragLeave",function(e){e.relatedTarget&&e.relatedTarget.closest(".iuw-root")===r.element||(r.dragging=!1,r.element.classList.remove("drop-zone"))}),_defineProperty(this,"closePreviewModal",function(){document.body.style.overflow="auto";var t=document.getElementById("iuw-modal-element");t&&(t.classList.remove("visible"),t.classList.add("hide"),setTimeout(function(){var e;null!==(e=t.parentElement)&&void 0!==e&&e.removeChild(t)},300))}),_defineProperty(this,"onModalClick",function(e){if(e&&e.target&&e.target.closest("img.iuw-modal-image-preview-item"))return;r.closePreviewModal()}),_defineProperty(this,"createPreviewModal",function(e){e.className="",e.classList.add("iuw-modal-image-preview-item");var t=document.createElement("div");t.id="iuw-modal-element",t.classList.add("iuw-modal","hide"),t.addEventListener("click",r.onModalClick);var i=document.createElement("div");return i.classList.add("iuw-modal-image-preview"),i.innerHTML='<span class="iuw-modal-close"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" width="100%" height="100%"><path xmlns="http://www.w3.org/2000/svg" d="m289.94 256 95-95A24 24 0 0 0 351 127l-95 95-95-95a24 24 0 0 0-34 34l95 95-95 95a24 24 0 1 0 34 34l95-95 95 95a24 24 0 0 0 34-34z"></path></svg></span>',i.appendChild(e),t.appendChild(i),document.body.appendChild(t),t}),_defineProperty(this,"onImagePreviewClick",function(e){if(e&&e.target){var t=e.target;if(t.closest(".iuw-delete-icon")){var i=t.closest(".iuw-image-preview");return null==i||null!==(e=i.parentElement)&&void 0!==e&&e.removeChild(i),r.checkboxInput&&(r.checkboxInput.checked=!0),r.fileInput.value="",r.file=null,r.raw=null,void r.renderWidget()}if(t.closest(".iuw-preview-icon")){var t=t.closest(".iuw-image-preview");if(t=null==t?void 0:t.querySelector("img")){var t=t.cloneNode(!0),n=r.createPreviewModal(t);return void setTimeout(function(){n.classList.add("visible"),n.classList.remove("hide"),document.body.style.overflow="hidden"},50)}}}r.fileInput.click()}),_defineProperty(this,"onFileInputChange",function(){var e;null!==(e=r.fileInput.files)&&void 0!==e&&e.length&&(r.file=r.fileInput.files[0]),r.renderWidget()});var t=(this.element=e).querySelector("input[type=file]"),i=e.querySelector("input[type=checkbox]");if(!t)throw new Error("no-file-input-found");this.fileInput=t,this.checkboxInput=i,this.emptyMarker=e.querySelector(".iuw-empty"),this.canDelete="true"===e.getAttribute("data-candelete"),this.dragging=!1,this.fileInput.addEventListener("change",this.onFileInputChange),this.emptyMarker&&this.emptyMarker.addEventListener("click",this.onEmptyMarkerClick),this.element.addEventListener("dragenter",this.onDragEnter),this.element.addEventListener("dragover",this.onDragOver),this.element.addEventListener("dragleave",this.onDragLeave),this.element.addEventListener("dragend",this.onDragLeave),this.element.addEventListener("drop",this.onDrop),this.raw=e.getAttribute("data-raw"),this.file=null,this.renderWidget()}return _createClass(n,[{key:"renderPreview",value:function(e){var t=document.createElement("div");t.classList.add("iuw-image-preview");var i,n=document.createElement("img");return n.src=e,t.appendChild(n),this.canDelete&&((i=document.createElement("span")).classList.add("iuw-delete-icon"),i.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" width="100%" height="100%"><path xmlns="http://www.w3.org/2000/svg" d="m289.94 256 95-95A24 24 0 0 0 351 127l-95 95-95-95a24 24 0 0 0-34 34l95 95-95 95a24 24 0 1 0 34 34l95-95 95 95a24 24 0 0 0 34-34z"></path></svg>',t.appendChild(i)),this.canPreview&&((i=document.createElement("span")).classList.add("iuw-preview-icon"),this.canDelete||i.classList.add("iuw-only-preview"),i.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="bi bi-zoom-in" viewBox="0 0 16 16" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" width="100%" height="100%"><path xmlns="http://www.w3.org/2000/svg" fill-rule="evenodd" d="M6.5 12a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11zM13 6.5a6.5 6.5 0 1 1-13 0 6.5 6.5 0 0 1 13 0z"></path><path xmlns="http://www.w3.org/2000/svg" d="M10.344 11.742c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1 6.538 6.538 0 0 1-1.398 1.4z"></path><path xmlns="http://www.w3.org/2000/svg" fill-rule="evenodd" d="M6.5 3a.5.5 0 0 1 .5.5V6h2.5a.5.5 0 0 1 0 1H7v2.5a.5.5 0 0 1-1 0V7H3.5a.5.5 0 0 1 0-1H6V3.5a.5.5 0 0 1 .5-.5z"></path></svg>',t.appendChild(i)),t}},{key:"renderWidget",value:function(){var e,t=this;this.file||this.raw?(this.element.classList.add("non-empty"),this.checkboxInput&&(this.checkboxInput.checked=!1)):(this.element.classList.remove("non-empty"),this.checkboxInput&&(this.checkboxInput.checked=!0)),Array.from(this.element.querySelectorAll(".iuw-image-preview")).forEach(function(e){return t.element.removeChild(e)}),this.file?(e=URL.createObjectURL(this.file),this.element.appendChild(this.renderPreview(e))):this.raw&&this.element.appendChild(this.renderPreview(this.raw)),Array.from(this.element.querySelectorAll(".iuw-image-preview")).forEach(function(e){return e.addEventListener("click",t.onImagePreviewClick)})}}]),n}();document.addEventListener("DOMContentLoaded",function(){Array.from(document.querySelectorAll(".iuw-root")).map(function(e){return new ImageUploaderWidget(e)}),window&&window.django&&window.django.jQuery&&(0,window.django.jQuery)(document).on("formset:added",function(e,t){t.length&&Array.from(t[0].querySelectorAll(".iuw-root")).map(function(e){return new ImageUploaderWidget(e)})})});