# Generated by Django 2.2.24 on 2021-07-30 15:25

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import mptt.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('NEMO', '0032_version_3_11_0'),
        ('NEMO_transaction_validation', '0001_NEMO_transaction_validation_0_0_1'),
    ]

    operations = [
        migrations.CreateModel(
            name='ContestAreaAccessRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField(blank=True, null=True)),
                ('end', models.DateTimeField(blank=True, null=True)),
                ('original', models.BooleanField(default=False, help_text='Original Area Access Record data')),
                ('admin_approved', models.BooleanField(default=False, help_text='<b>Check this to approve the contest and to apply the changes when saving this form</b>')),
                ('area', mptt.fields.TreeForeignKey(blank=True, help_text='The area accessed during this record', null=True, on_delete=django.db.models.deletion.CASCADE, to='NEMO.Area')),
                ('transaction', models.ForeignKey(help_text='Area Access Record to be contested', on_delete=django.db.models.deletion.CASCADE, to='NEMO.AreaAccessRecord')),
            ],
            options={
                'ordering': ['transaction'],
            },
        ),
        migrations.CreateModel(
            name='ContestStaffCharge',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField()),
                ('end', models.DateTimeField(blank=True, null=True)),
                ('reason', models.TextField(choices=[('operator', 'Incorrect operator selection'), ('customer', 'Incorrect customer selection'), ('project', 'Incorrect project selection'), ('datetime', 'Incorrect date/time selection'), ('area', 'Incorrect area access record(s)'), ('original', 'Original staff charge')], help_text='Provide the reason for submitting this transaction contest')),
                ('description', models.TextField(blank=True, help_text='Provide a detailed reason for submitting this transaction contest', null=True)),
                ('admin_approved', models.BooleanField(default=False, help_text='<b>Check this to approve the contest and to apply the changes when saving this form</b>')),
                ('area_access_records', models.ManyToManyField(blank=True, help_text='Area Access Record contests', null=True, to='NEMO_transaction_validation.ContestAreaAccessRecord')),
                ('operator', models.ForeignKey(help_text='Staff that performed the transaction on behalf of the customer', on_delete=django.db.models.deletion.CASCADE, related_name='contest_sc_operator', to=settings.AUTH_USER_MODEL)),
                ('project', models.ForeignKey(help_text='Transaction will be billed to this project', on_delete=django.db.models.deletion.CASCADE, to='NEMO.Project')),
                ('transaction', models.ForeignKey(help_text='Staff Charge to be contested', on_delete=django.db.models.deletion.CASCADE, to='NEMO.StaffCharge')),
                ('user', models.ForeignKey(help_text='Customer that the staff performed the task on behalf of', on_delete=django.db.models.deletion.CASCADE, related_name='contest_sc_customer', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['operator'],
            },
        ),
        migrations.CreateModel(
            name='ContestUsageEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField()),
                ('end', models.DateTimeField(blank=True, null=True)),
                ('reason', models.TextField(choices=[('operator', 'Incorrect operator selection'), ('customer', 'Incorrect customer selection'), ('project', 'Incorrect project selection'), ('datetime', 'Incorrect date/time selection'), ('tool', 'Incorrect tool selection'), ('original', 'Original usage event')], help_text='Provide the reason for submitting this transaction contest')),
                ('description', models.TextField(blank=True, help_text='Provide a detailed reason for submitting this transaction contest', null=True)),
                ('admin_approved', models.BooleanField(default=False, help_text='<b>Check this to approve the contest and to apply the changes when saving this form</b>')),
                ('operator', models.ForeignKey(help_text='Staff that performed the transaction on behalf of the customer', on_delete=django.db.models.deletion.CASCADE, related_name='contest_ue_operator', to=settings.AUTH_USER_MODEL)),
                ('project', models.ForeignKey(help_text='Transaction will be billed to this project', on_delete=django.db.models.deletion.CASCADE, to='NEMO.Project')),
                ('tool', models.ForeignKey(help_text='The tool used during this transaction', on_delete=django.db.models.deletion.CASCADE, to='NEMO.Tool')),
                ('transaction', models.ForeignKey(help_text='Usage Event to be contested', on_delete=django.db.models.deletion.CASCADE, to='NEMO.UsageEvent')),
                ('user', models.ForeignKey(help_text='Customer that the staff performed the task on behalf of', on_delete=django.db.models.deletion.CASCADE, related_name='contest_ue_customer', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['operator'],
            },
        ),
        migrations.DeleteModel(
            name='Contest',
        ),
    ]
