# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from lndgrpc.compiled import signer_pb2 as lndgrpc_dot_compiled_dot_signer__pb2


class SignerStub(object):
    """Signer is a service that gives access to the signing functionality of the
    daemon's wallet.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.SignOutputRaw = channel.unary_unary(
                '/signrpc.Signer/SignOutputRaw',
                request_serializer=lndgrpc_dot_compiled_dot_signer__pb2.SignReq.SerializeToString,
                response_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.SignResp.FromString,
                )
        self.ComputeInputScript = channel.unary_unary(
                '/signrpc.Signer/ComputeInputScript',
                request_serializer=lndgrpc_dot_compiled_dot_signer__pb2.SignReq.SerializeToString,
                response_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.InputScriptResp.FromString,
                )
        self.SignMessage = channel.unary_unary(
                '/signrpc.Signer/SignMessage',
                request_serializer=lndgrpc_dot_compiled_dot_signer__pb2.SignMessageReq.SerializeToString,
                response_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.SignMessageResp.FromString,
                )
        self.VerifyMessage = channel.unary_unary(
                '/signrpc.Signer/VerifyMessage',
                request_serializer=lndgrpc_dot_compiled_dot_signer__pb2.VerifyMessageReq.SerializeToString,
                response_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.VerifyMessageResp.FromString,
                )
        self.DeriveSharedKey = channel.unary_unary(
                '/signrpc.Signer/DeriveSharedKey',
                request_serializer=lndgrpc_dot_compiled_dot_signer__pb2.SharedKeyRequest.SerializeToString,
                response_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.SharedKeyResponse.FromString,
                )
        self.MuSig2CombineKeys = channel.unary_unary(
                '/signrpc.Signer/MuSig2CombineKeys',
                request_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineKeysRequest.SerializeToString,
                response_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineKeysResponse.FromString,
                )
        self.MuSig2CreateSession = channel.unary_unary(
                '/signrpc.Signer/MuSig2CreateSession',
                request_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SessionRequest.SerializeToString,
                response_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SessionResponse.FromString,
                )
        self.MuSig2RegisterNonces = channel.unary_unary(
                '/signrpc.Signer/MuSig2RegisterNonces',
                request_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2RegisterNoncesRequest.SerializeToString,
                response_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2RegisterNoncesResponse.FromString,
                )
        self.MuSig2Sign = channel.unary_unary(
                '/signrpc.Signer/MuSig2Sign',
                request_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SignRequest.SerializeToString,
                response_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SignResponse.FromString,
                )
        self.MuSig2CombineSig = channel.unary_unary(
                '/signrpc.Signer/MuSig2CombineSig',
                request_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineSigRequest.SerializeToString,
                response_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineSigResponse.FromString,
                )
        self.MuSig2Cleanup = channel.unary_unary(
                '/signrpc.Signer/MuSig2Cleanup',
                request_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CleanupRequest.SerializeToString,
                response_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CleanupResponse.FromString,
                )


class SignerServicer(object):
    """Signer is a service that gives access to the signing functionality of the
    daemon's wallet.
    """

    def SignOutputRaw(self, request, context):
        """
        SignOutputRaw is a method that can be used to generated a signature for a
        set of inputs/outputs to a transaction. Each request specifies details
        concerning how the outputs should be signed, which keys they should be
        signed with, and also any optional tweaks. The return value is a fixed
        64-byte signature (the same format as we use on the wire in Lightning).

        If we are  unable to sign using the specified keys, then an error will be
        returned.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ComputeInputScript(self, request, context):
        """
        ComputeInputScript generates a complete InputIndex for the passed
        transaction with the signature as defined within the passed SignDescriptor.
        This method should be capable of generating the proper input script for both
        regular p2wkh/p2tr outputs and p2wkh outputs nested within a regular p2sh
        output.

        Note that when using this method to sign inputs belonging to the wallet,
        the only items of the SignDescriptor that need to be populated are pkScript
        in the TxOut field, the value in that same field, and finally the input
        index.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SignMessage(self, request, context):
        """
        SignMessage signs a message with the key specified in the key locator. The
        returned signature is fixed-size LN wire format encoded.

        The main difference to SignMessage in the main RPC is that a specific key is
        used to sign the message instead of the node identity private key.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def VerifyMessage(self, request, context):
        """
        VerifyMessage verifies a signature over a message using the public key
        provided. The signature must be fixed-size LN wire format encoded.

        The main difference to VerifyMessage in the main RPC is that the public key
        used to sign the message does not have to be a node known to the network.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeriveSharedKey(self, request, context):
        """
        DeriveSharedKey returns a shared secret key by performing Diffie-Hellman key
        derivation between the ephemeral public key in the request and the node's
        key specified in the key_desc parameter. Either a key locator or a raw
        public key is expected in the key_desc, if neither is supplied, defaults to
        the node's identity private key:
        P_shared = privKeyNode * ephemeralPubkey
        The resulting shared public key is serialized in the compressed format and
        hashed with sha256, resulting in the final key length of 256bit.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MuSig2CombineKeys(self, request, context):
        """
        MuSig2CombineKeys (experimental!) is a stateless helper RPC that can be used
        to calculate the combined MuSig2 public key from a list of all participating
        signers' public keys. This RPC is completely stateless and deterministic and
        does not create any signing session. It can be used to determine the Taproot
        public key that should be put in an on-chain output once all public keys are
        known. A signing session is only needed later when that output should be
        _spent_ again.

        NOTE: The MuSig2 BIP is not final yet and therefore this API must be
        considered to be HIGHLY EXPERIMENTAL and subject to change in upcoming
        releases. Backward compatibility is not guaranteed!
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MuSig2CreateSession(self, request, context):
        """
        MuSig2CreateSession (experimental!) creates a new MuSig2 signing session
        using the local key identified by the key locator. The complete list of all
        public keys of all signing parties must be provided, including the public
        key of the local signing key. If nonces of other parties are already known,
        they can be submitted as well to reduce the number of RPC calls necessary
        later on.

        NOTE: The MuSig2 BIP is not final yet and therefore this API must be
        considered to be HIGHLY EXPERIMENTAL and subject to change in upcoming
        releases. Backward compatibility is not guaranteed!
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MuSig2RegisterNonces(self, request, context):
        """
        MuSig2RegisterNonces (experimental!) registers one or more public nonces of
        other signing participants for a session identified by its ID. This RPC can
        be called multiple times until all nonces are registered.

        NOTE: The MuSig2 BIP is not final yet and therefore this API must be
        considered to be HIGHLY EXPERIMENTAL and subject to change in upcoming
        releases. Backward compatibility is not guaranteed!
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MuSig2Sign(self, request, context):
        """
        MuSig2Sign (experimental!) creates a partial signature using the local
        signing key that was specified when the session was created. This can only
        be called when all public nonces of all participants are known and have been
        registered with the session. If this node isn't responsible for combining
        all the partial signatures, then the cleanup flag should be set, indicating
        that the session can be removed from memory once the signature was produced.

        NOTE: The MuSig2 BIP is not final yet and therefore this API must be
        considered to be HIGHLY EXPERIMENTAL and subject to change in upcoming
        releases. Backward compatibility is not guaranteed!
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MuSig2CombineSig(self, request, context):
        """
        MuSig2CombineSig (experimental!) combines the given partial signature(s)
        with the local one, if it already exists. Once a partial signature of all
        participants is registered, the final signature will be combined and
        returned.

        NOTE: The MuSig2 BIP is not final yet and therefore this API must be
        considered to be HIGHLY EXPERIMENTAL and subject to change in upcoming
        releases. Backward compatibility is not guaranteed!
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MuSig2Cleanup(self, request, context):
        """
        MuSig2Cleanup (experimental!) allows a caller to clean up a session early in
        cases where it's obvious that the signing session won't succeed and the
        resources can be released.

        NOTE: The MuSig2 BIP is not final yet and therefore this API must be
        considered to be HIGHLY EXPERIMENTAL and subject to change in upcoming
        releases. Backward compatibility is not guaranteed!
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_SignerServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'SignOutputRaw': grpc.unary_unary_rpc_method_handler(
                    servicer.SignOutputRaw,
                    request_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.SignReq.FromString,
                    response_serializer=lndgrpc_dot_compiled_dot_signer__pb2.SignResp.SerializeToString,
            ),
            'ComputeInputScript': grpc.unary_unary_rpc_method_handler(
                    servicer.ComputeInputScript,
                    request_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.SignReq.FromString,
                    response_serializer=lndgrpc_dot_compiled_dot_signer__pb2.InputScriptResp.SerializeToString,
            ),
            'SignMessage': grpc.unary_unary_rpc_method_handler(
                    servicer.SignMessage,
                    request_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.SignMessageReq.FromString,
                    response_serializer=lndgrpc_dot_compiled_dot_signer__pb2.SignMessageResp.SerializeToString,
            ),
            'VerifyMessage': grpc.unary_unary_rpc_method_handler(
                    servicer.VerifyMessage,
                    request_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.VerifyMessageReq.FromString,
                    response_serializer=lndgrpc_dot_compiled_dot_signer__pb2.VerifyMessageResp.SerializeToString,
            ),
            'DeriveSharedKey': grpc.unary_unary_rpc_method_handler(
                    servicer.DeriveSharedKey,
                    request_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.SharedKeyRequest.FromString,
                    response_serializer=lndgrpc_dot_compiled_dot_signer__pb2.SharedKeyResponse.SerializeToString,
            ),
            'MuSig2CombineKeys': grpc.unary_unary_rpc_method_handler(
                    servicer.MuSig2CombineKeys,
                    request_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineKeysRequest.FromString,
                    response_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineKeysResponse.SerializeToString,
            ),
            'MuSig2CreateSession': grpc.unary_unary_rpc_method_handler(
                    servicer.MuSig2CreateSession,
                    request_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SessionRequest.FromString,
                    response_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SessionResponse.SerializeToString,
            ),
            'MuSig2RegisterNonces': grpc.unary_unary_rpc_method_handler(
                    servicer.MuSig2RegisterNonces,
                    request_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2RegisterNoncesRequest.FromString,
                    response_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2RegisterNoncesResponse.SerializeToString,
            ),
            'MuSig2Sign': grpc.unary_unary_rpc_method_handler(
                    servicer.MuSig2Sign,
                    request_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SignRequest.FromString,
                    response_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SignResponse.SerializeToString,
            ),
            'MuSig2CombineSig': grpc.unary_unary_rpc_method_handler(
                    servicer.MuSig2CombineSig,
                    request_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineSigRequest.FromString,
                    response_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineSigResponse.SerializeToString,
            ),
            'MuSig2Cleanup': grpc.unary_unary_rpc_method_handler(
                    servicer.MuSig2Cleanup,
                    request_deserializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CleanupRequest.FromString,
                    response_serializer=lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CleanupResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'signrpc.Signer', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Signer(object):
    """Signer is a service that gives access to the signing functionality of the
    daemon's wallet.
    """

    @staticmethod
    def SignOutputRaw(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/signrpc.Signer/SignOutputRaw',
            lndgrpc_dot_compiled_dot_signer__pb2.SignReq.SerializeToString,
            lndgrpc_dot_compiled_dot_signer__pb2.SignResp.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ComputeInputScript(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/signrpc.Signer/ComputeInputScript',
            lndgrpc_dot_compiled_dot_signer__pb2.SignReq.SerializeToString,
            lndgrpc_dot_compiled_dot_signer__pb2.InputScriptResp.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SignMessage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/signrpc.Signer/SignMessage',
            lndgrpc_dot_compiled_dot_signer__pb2.SignMessageReq.SerializeToString,
            lndgrpc_dot_compiled_dot_signer__pb2.SignMessageResp.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def VerifyMessage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/signrpc.Signer/VerifyMessage',
            lndgrpc_dot_compiled_dot_signer__pb2.VerifyMessageReq.SerializeToString,
            lndgrpc_dot_compiled_dot_signer__pb2.VerifyMessageResp.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeriveSharedKey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/signrpc.Signer/DeriveSharedKey',
            lndgrpc_dot_compiled_dot_signer__pb2.SharedKeyRequest.SerializeToString,
            lndgrpc_dot_compiled_dot_signer__pb2.SharedKeyResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def MuSig2CombineKeys(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/signrpc.Signer/MuSig2CombineKeys',
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineKeysRequest.SerializeToString,
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineKeysResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def MuSig2CreateSession(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/signrpc.Signer/MuSig2CreateSession',
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SessionRequest.SerializeToString,
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SessionResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def MuSig2RegisterNonces(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/signrpc.Signer/MuSig2RegisterNonces',
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2RegisterNoncesRequest.SerializeToString,
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2RegisterNoncesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def MuSig2Sign(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/signrpc.Signer/MuSig2Sign',
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SignRequest.SerializeToString,
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2SignResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def MuSig2CombineSig(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/signrpc.Signer/MuSig2CombineSig',
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineSigRequest.SerializeToString,
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CombineSigResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def MuSig2Cleanup(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/signrpc.Signer/MuSig2Cleanup',
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CleanupRequest.SerializeToString,
            lndgrpc_dot_compiled_dot_signer__pb2.MuSig2CleanupResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
