"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Server = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process_1 = require("child_process");
const fs_1 = require("fs");
const http_1 = require("http");
const os_1 = require("os");
const path_1 = require("path");
class Server {
    constructor(props) {
        this.appCommand = props.appCommand;
        this.server = http_1.createServer((req, res) => this.handleRequest(req, res).catch(e => {
            console.error('server error: ', e);
            res.statusCode = 500;
            res.write(e.message);
            res.end();
        }));
        this.tmpdir = fs_1.mkdtempSync(path_1.join(os_1.tmpdir(), 'cdk8s-operator-'));
    }
    /**
     * Starts HTTP server.
     * @param port The port to listen to. If not specified, the `PORT` environment
     * variable will be used. If that's not specified an available port will be
     * auto-selected.
     */
    async listen(port) {
        var _b;
        const lport = (_b = port !== null && port !== void 0 ? port : process.env.PORT) !== null && _b !== void 0 ? _b : 0;
        return new Promise((ok, ko) => {
            this.server.listen(lport, () => {
                const addr = this.server.address();
                if (typeof (addr) === 'string') {
                    throw new Error(`cannot determine port from server address ${addr}`);
                }
                return ok(addr === null || addr === void 0 ? void 0 : addr.port);
            });
            this.server.on('error', err => ko(err));
        });
    }
    /**
     * Stop server.
     */
    close() {
        this.server.close();
    }
    async handleRequest(req, res) {
        const inputfile = await this.writeInputFile(req);
        const child = child_process_1.spawn(this.appCommand, [inputfile], {
            stdio: ['ignore', 'pipe', 'pipe'],
            shell: true,
        });
        const stderr = new Array();
        res.setHeader('Content-Type', 'application/json');
        // stdout should go directly to the response
        child.stdout.on('data', chunk => {
            process.stderr.write('output: ' + chunk);
            res.write(chunk);
        });
        // for stderr: write to server terminal and only send back if we exited with a non-zero
        child.stderr.on('data', chunk => {
            process.stderr.write(chunk);
            stderr.push(chunk);
        });
        // will be caused by the async handler and 500 will be returned.
        child.on('error', err => {
            throw err;
        });
        child.on('exit', code => {
            if (code !== 0) {
                res.statusCode = 500;
                for (const c of stderr) {
                    res.write(c);
                }
                res.end();
            }
            // success
            return res.end();
        });
    }
    async writeInputFile(req) {
        return new Promise((ok, ko) => {
            const inputfile = path_1.join(this.tmpdir, `input-${Math.round(Math.random() * 999999)}.json`);
            const input = fs_1.createWriteStream(inputfile);
            req.pipe(input);
            input.on('close', () => {
                try {
                    const inputJson = JSON.parse(fs_1.readFileSync(inputfile, 'utf-8'));
                    console.error(`input: ${JSON.stringify(inputJson)}`);
                    return ok(inputfile);
                }
                catch (e) {
                    return ko(new Error(`unable to parse request body as JSON: ${e}`));
                }
            });
            req.on('error', err => ko(err.message));
        });
    }
}
exports.Server = Server;
_a = JSII_RTTI_SYMBOL_1;
Server[_a] = { fqn: "cdk8s-operator.Server", version: "0.1.0" };
//# sourceMappingURL=data:application/json;base64,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