"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretGenerator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class SecretGenerator extends core_1.Construct {
    constructor(scope, id, props = {}) {
        var _b, _c;
        super(scope, id);
        const secretGenerator = new aws_lambda_1.SingletonFunction(this, 'Function', {
            uuid: 'cloudcomponents-cdk-cloudfront-authorization-secret-generator',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'secret-generator')),
        });
        const cr = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: secretGenerator.functionArn,
            resourceType: 'Custom::GenerateSecret',
            properties: {
                Length: (_b = props.length) !== null && _b !== void 0 ? _b : 16,
                AllowedCharacters: (_c = props.allowedCharacters) !== null && _c !== void 0 ? _c : 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~',
            },
        });
        this.secret = cr.ref;
    }
}
exports.SecretGenerator = SecretGenerator;
_a = JSII_RTTI_SYMBOL_1;
SecretGenerator[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.SecretGenerator", version: "1.43.0" };
//# sourceMappingURL=data:application/json;base64,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