# Generated by Django 3.2.12 on 2022-03-15 08:53

from django.db import migrations, models
import wagtail.core.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CookieConsentLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('consent_token', models.CharField(max_length=50, unique=True, verbose_name='Chiave consenso')),
                ('consent_url', models.URLField(verbose_name='Consenso Cookie Url')),
                ('consent_date_time', models.DateTimeField(auto_now_add=True, verbose_name='Data e Ora')),
                ('consent_user_agent', models.TextField(verbose_name='User Agent')),
                ('consent_anonymize_ip', models.CharField(max_length=20, verbose_name='IP Anonymize')),
                ('consent_cookie', models.TextField(verbose_name='Lista cookie accettati')),
            ],
            options={
                'verbose_name_plural': 'Cookie Log',
                'ordering': ['-consent_date_time'],
            },
        ),
        migrations.CreateModel(
            name='CookieConsentSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title_banner', models.CharField(blank=True, max_length=255, verbose_name='Titolo banner')),
                ('title_modal', models.CharField(blank=True, max_length=255, verbose_name='Titolo modal')),
                ('description_banner', wagtail.core.fields.RichTextField(blank=True, verbose_name='Descrizione banner')),
                ('description_modal', wagtail.core.fields.RichTextField(blank=True, verbose_name='Descrizione modal')),
                ('description_technical', wagtail.core.fields.RichTextField(blank=True, verbose_name='Descrizione cookie tecnici')),
                ('description_analytics', wagtail.core.fields.RichTextField(blank=True, verbose_name='Descrizione cookie statistici')),
                ('description_marketing', wagtail.core.fields.RichTextField(blank=True, verbose_name='Descrizione cookie marketing')),
                ('description_information', wagtail.core.fields.RichTextField(blank=True, verbose_name='Maggiori informazioni')),
                ('layout_banner', models.CharField(choices=[('box', 'Box'), ('cloud', 'Cloud'), ('bar', 'Bar')], default='box', max_length=255, verbose_name='Layout banner')),
                ('position_y_banner', models.CharField(choices=[('top', 'Top'), ('middle', 'Middle'), ('bottom', 'Bottom')], default='bottom', max_length=255, verbose_name='Posizione Y banner')),
                ('position_x_banner', models.CharField(choices=[('left', 'Left'), ('center', 'Center'), ('right', 'Right')], default='left', max_length=255, verbose_name='Posizione X banner')),
                ('layout_modal', models.CharField(choices=[('box', 'Box'), ('bar', 'Bar')], default='box', max_length=255, verbose_name='Layout modal')),
                ('position_modal', models.CharField(choices=[('left', 'Left'), ('right', 'Right')], default='left', max_length=255, verbose_name='Posizione modal')),
                ('banner_is_active', models.BooleanField(default=True, verbose_name='Attivare il banner?')),
                ('revision_banner', models.IntegerField(default=0)),
            ],
            options={
                'verbose_name_plural': 'Cookie settings',
            },
        ),
        migrations.CreateModel(
            name='CookieScript',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cookie_name', models.CharField(max_length=200, verbose_name='Nome')),
                ('cookie_type', models.IntegerField(choices=[(0, 'Tecnici/Necessari'), (1, 'Statistiche'), (2, 'Marketing')], default=1, verbose_name='Tipologia')),
                ('cookie_script', models.TextField(verbose_name='Script JS')),
            ],
            options={
                'verbose_name_plural': 'Cookie Scripts',
                'ordering': ['cookie_type'],
            },
        ),
    ]
