import pymysql


# mysql操作类
class MySql:
    def __init__(self, host, username, password, database, port=3306, charset='utf8'):
        self.host = host
        self.port = port
        self.username = username
        self.password = password
        self.database = database
        self.charset = charset

    # 连接mysql方法
    def _connect(self):
        return pymysql.connect(host=self.host,
                               port=self.port,
                               user=self.username,
                               passwd=self.password,
                               db=self.database,
                               charset=self.charset)

    # 插入方法
    def insert(self, sql):
        conn = self._connect()
        cursor = conn.cursor()
        cursor.execute(sql)
        conn.commit()
        affected_rows = conn.affected_rows()
        cursor.close()
        conn.close()
        return affected_rows

    # 修改方法
    def update(self, sql):
        conn = self._connect()
        cursor = conn.cursor()
        cursor.execute(sql)
        conn.commit()
        affected_rows = conn.affected_rows()
        cursor.close()
        conn.close()
        return affected_rows

    # 删除方法
    def delete(self, sql):
        conn = self._connect()
        cursor = conn.cursor()
        cursor.execute(sql)
        conn.commit()
        affected_rows = conn.affected_rows()
        cursor.close()
        conn.close()
        return affected_rows

    # 查询所有数据，结果以元祖方式返回
    def query_all(self, sql):
        conn = self._connect()
        cursor = conn.cursor()
        cursor.execute(sql)
        data = cursor.fetchall()
        cursor.close()
        conn.close()
        return data

    # 查询所有数据，结果以字典方式返回
    def query_all_dict(self, sql):
        conn = self._connect()
        cursor = conn.cursor(cursor=pymysql.cursors.DictCursor)
        cursor.execute(sql)
        data = cursor.fetchall()
        cursor.close()
        conn.close()
        return data

    # 查询单条数据，结果以元祖方式返回
    def query_one(self, sql):
        conn = self._connect()
        cursor = conn.cursor()
        cursor.execute(sql)
        data = cursor.fetchone()
        cursor.close()
        conn.close()
        return data

    # 查询单条数据，结果以字典方式返回
    def query_one_dict(self, sql):
        conn = self._connect()
        cursor = conn.cursor(cursor=pymysql.cursors.DictCursor)
        cursor.execute(sql)
        data = cursor.fetchone()
        cursor.close()
        conn.close()
        return data
