/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.apidb.v0_6.ApidbVersionConstants;
import org.openstreetmap.osmosis.apidb.v0_6.impl.SchemaVersionValidator;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.task.common.RunnableTask;

public class ApidbTruncator
implements RunnableTask {
    private static final List<String> TRUNCATE_TABLES = Arrays.asList("current_relation_members", "current_relation_tags", "current_relations", "current_way_nodes", "current_way_tags", "current_ways", "current_node_tags", "current_nodes", "relation_members", "relation_tags", "relations", "way_nodes", "way_tags", "ways", "node_tags", "nodes", "changeset_tags", "changesets", "users");
    private DatabaseLoginCredentials loginCredentials;
    private final SchemaVersionValidator schemaVersionValidator;

    public ApidbTruncator(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences) {
        this.loginCredentials = loginCredentials;
        this.schemaVersionValidator = new SchemaVersionValidator(loginCredentials, preferences);
    }

    public void run() {
        try (DatabaseContext dbCtx = new DatabaseContext(this.loginCredentials);){
            this.schemaVersionValidator.validateVersion(ApidbVersionConstants.SCHEMA_MIGRATIONS);
            dbCtx.truncateTables(TRUNCATE_TABLES);
            dbCtx.commit();
        }
    }
}

