/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6.impl;

import java.io.File;
import java.util.Properties;
import org.openstreetmap.osmosis.core.util.PropertiesPersister;

public class IntervalDownloaderConfiguration {
    private static final String KEY_BASE_URL = "baseUrl";
    private static final String KEY_CHANGE_FILE_BEGIN_FORMAT = "changeFileBeginFormat";
    private static final String KEY_CHANGE_FILE_END_FORMAT = "changeFileEndFormat";
    private static final String KEY_INTERVAL_LENGTH = "intervalLength";
    private static final String KEY_MAX_DOWNLOAD_COUNT = "maxDownloadCount";
    private Properties properties;

    public IntervalDownloaderConfiguration(File configFile) {
        this.properties = new PropertiesPersister(configFile).load();
    }

    public String getBaseUrl() {
        String baseUrl = this.properties.getProperty(KEY_BASE_URL);
        if (!baseUrl.substring(baseUrl.length() - 1).equals("/")) {
            baseUrl = baseUrl + "/";
        }
        return baseUrl;
    }

    public String getChangeFileBeginFormat() {
        return this.properties.getProperty(KEY_CHANGE_FILE_BEGIN_FORMAT);
    }

    public String getChangeFileEndFormat() {
        return this.properties.getProperty(KEY_CHANGE_FILE_END_FORMAT);
    }

    public int getIntervalLength() {
        return Integer.parseInt(this.properties.getProperty(KEY_INTERVAL_LENGTH)) * 1000;
    }

    public int getMaxDownloadCount() {
        return Integer.parseInt(this.properties.getProperty(KEY_MAX_DOWNLOAD_COUNT));
    }
}

