/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.util.AtomicFileCreator;

public class PropertiesPersister {
    private AtomicFileCreator atomicFileCreator;

    public PropertiesPersister(File propertiesFile) {
        this.atomicFileCreator = new AtomicFileCreator(propertiesFile);
    }

    public Properties load() {
        Properties properties;
        FileInputStream fileInputStream = new FileInputStream(this.atomicFileCreator.getFile());
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(fileInputStream), Charset.forName("UTF-8"));
            Properties properties2 = new Properties();
            properties2.load(reader);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to read the properties from file " + this.atomicFileCreator.getFile() + ".", e);
            }
        }
        fileInputStream.close();
        return properties;
    }

    public Map<String, String> loadMap() {
        return new HashMap<Object, Object>(this.load());
    }

    public void store(Properties properties) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.atomicFileCreator.getTmpFile());){
            OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(fileOutputStream));
            properties.store(writer, null);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write the properties to temporary file " + this.atomicFileCreator.getTmpFile() + ".", e);
        }
        this.atomicFileCreator.renameTmpFileToCurrent();
    }

    public void store(Map<String, String> propertiesMap) {
        Properties properties = new Properties();
        properties.putAll(propertiesMap);
        this.store(properties);
    }

    public boolean exists() {
        return this.atomicFileCreator.exists();
    }
}

