/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.filter.common;

import java.util.Iterator;
import org.openstreetmap.osmosis.core.filter.common.BitSetIdTracker;
import org.openstreetmap.osmosis.core.filter.common.IdTracker;
import org.openstreetmap.osmosis.core.filter.common.ListIdTracker;

public class DynamicIdTrackerSegment
implements Comparable<DynamicIdTrackerSegment>,
Iterable<Long> {
    private static final int BITSET_THRESHOLD = 32;
    private long base;
    private char setCount;
    private IdTracker idTracker;
    private boolean bitsetEnabled;

    public DynamicIdTrackerSegment(long base) {
        this.base = base;
        this.idTracker = new ListIdTracker();
        this.bitsetEnabled = false;
    }

    public long getBase() {
        return this.base;
    }

    public long getSetCount() {
        return this.setCount;
    }

    public boolean get(long id) {
        return this.idTracker.get(id);
    }

    public void set(long id) {
        if (!this.idTracker.get(id)) {
            this.idTracker.set(id);
            this.setCount = (char)(this.setCount + '\u0001');
            if (!this.bitsetEnabled && this.setCount > ' ') {
                BitSetIdTracker bitsetIdTracker = new BitSetIdTracker();
                bitsetIdTracker.setAll(this.idTracker);
                this.idTracker = bitsetIdTracker;
                this.bitsetEnabled = true;
            }
        }
    }

    @Override
    public int compareTo(DynamicIdTrackerSegment o) {
        long result = this.base - o.base;
        if (result == 0L) {
            return 0;
        }
        if (result > 0L) {
            return 1;
        }
        return -1;
    }

    @Override
    public Iterator<Long> iterator() {
        return this.idTracker.iterator();
    }
}

