/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.areafilter.v0_6;

import java.util.Iterator;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.filter.common.IdTracker;
import org.openstreetmap.osmosis.core.filter.common.IdTrackerFactory;
import org.openstreetmap.osmosis.core.filter.common.IdTrackerType;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SimpleObjectStore;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public abstract class AreaFilter
implements SinkSource,
EntityProcessor {
    private Sink sink;
    private IdTracker availableNodes;
    private IdTracker requiredNodes;
    private IdTracker availableWays;
    private IdTracker requiredWays;
    private IdTracker availableRelations;
    private IdTracker requiredRelations;
    private boolean clipIncompleteEntities;
    private boolean completeWays;
    private boolean completeRelations;
    private boolean storeEntities;
    private boolean cascadingRelations;
    private SimpleObjectStore<WayContainer> allWays;
    private SimpleObjectStore<NodeContainer> allNodes;
    private SimpleObjectStore<RelationContainer> allRelations;

    public AreaFilter(IdTrackerType idTrackerType, boolean clipIncompleteEntities, boolean completeWays, boolean completeRelations, boolean cascadingRelations) {
        this.clipIncompleteEntities = clipIncompleteEntities;
        this.completeWays = completeWays || completeRelations;
        this.completeRelations = completeRelations;
        this.cascadingRelations = cascadingRelations && !completeRelations && !completeWays;
        this.availableNodes = IdTrackerFactory.createInstance((IdTrackerType)idTrackerType);
        this.requiredNodes = IdTrackerFactory.createInstance((IdTrackerType)idTrackerType);
        this.availableWays = IdTrackerFactory.createInstance((IdTrackerType)idTrackerType);
        this.requiredWays = IdTrackerFactory.createInstance((IdTrackerType)idTrackerType);
        this.availableRelations = IdTrackerFactory.createInstance((IdTrackerType)idTrackerType);
        this.requiredRelations = IdTrackerFactory.createInstance((IdTrackerType)idTrackerType);
        boolean bl = this.storeEntities = completeWays || completeRelations;
        if (this.storeEntities) {
            this.allNodes = new SimpleObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(NodeContainer.class), "afn", true);
            this.allWays = new SimpleObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(WayContainer.class), "afw", true);
            this.allRelations = new SimpleObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(RelationContainer.class), "afr", true);
        } else if (cascadingRelations) {
            this.allRelations = new SimpleObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(RelationContainer.class), "afr", true);
        }
    }

    public void initialize(Map<String, Object> metaData) {
        this.sink.initialize(metaData);
    }

    public void process(EntityContainer entityContainer) {
        entityContainer.process((EntityProcessor)this);
    }

    public void process(BoundContainer boundContainer) {
        this.sink.process((EntityContainer)boundContainer);
    }

    protected abstract boolean isNodeWithinArea(Node var1);

    public void process(NodeContainer container) {
        Node node = container.getEntity();
        if (this.storeEntities) {
            this.allNodes.add((Storeable)container);
        }
        if (this.isNodeWithinArea(node)) {
            this.availableNodes.set(node.getId());
            if (!this.storeEntities) {
                this.emitNode(container);
            }
        }
    }

    public void process(WayContainer container) {
        Way way = container.getEntity();
        if (this.storeEntities) {
            this.allWays.add((Storeable)container);
        }
        boolean inArea = false;
        for (WayNode nodeReference : way.getWayNodes()) {
            if (!this.availableNodes.get(nodeReference.getNodeId())) continue;
            inArea = true;
            break;
        }
        if (inArea) {
            this.availableWays.set(way.getId());
            if (this.completeWays) {
                for (WayNode nodeReference : way.getWayNodes()) {
                    long nodeId = nodeReference.getNodeId();
                    if (this.availableNodes.get(nodeId)) continue;
                    this.requiredNodes.set(nodeId);
                }
            }
            if (!this.storeEntities) {
                this.emitWay(container);
            }
        }
    }

    public void process(RelationContainer container) {
        Relation relation = container.getEntity();
        boolean inArea = false;
        boolean holdBackRelation = false;
        for (RelationMember member : relation.getMembers()) {
            switch (member.getMemberType()) {
                case Node: {
                    inArea = this.availableNodes.get(member.getMemberId());
                    break;
                }
                case Way: {
                    inArea = this.availableWays.get(member.getMemberId());
                    break;
                }
                case Relation: {
                    inArea = this.availableRelations.get(member.getMemberId());
                    break;
                }
            }
            if (!inArea) continue;
            break;
        }
        if (this.cascadingRelations) {
            holdBackRelation = true;
        }
        if (this.storeEntities || holdBackRelation) {
            this.allRelations.add((Storeable)container);
        }
        if (inArea) {
            this.availableRelations.set(relation.getId());
            if (!this.storeEntities && !holdBackRelation) {
                this.emitRelation(container);
            }
        }
    }

    private void emitNode(NodeContainer nodeContainer) {
        this.sink.process((EntityContainer)nodeContainer);
    }

    private void emitWay(WayContainer wayContainer) {
        if (this.clipIncompleteEntities) {
            WayContainer filteredWayContainer = wayContainer.getWriteableInstance();
            Way filteredWay = filteredWayContainer.getEntity();
            Iterator i = filteredWay.getWayNodes().iterator();
            while (i.hasNext()) {
                WayNode nodeReference = (WayNode)i.next();
                if (this.availableNodes.get(nodeReference.getNodeId())) continue;
                i.remove();
            }
            if (filteredWay.getWayNodes().size() > 0) {
                this.sink.process((EntityContainer)filteredWayContainer);
            }
        } else {
            this.sink.process((EntityContainer)wayContainer);
        }
    }

    private void emitRelation(RelationContainer relationContainer) {
        if (this.clipIncompleteEntities) {
            RelationContainer filteredRelationContainer = relationContainer.getWriteableInstance();
            Relation filteredRelation = filteredRelationContainer.getEntity();
            Iterator i = filteredRelation.getMembers().iterator();
            while (i.hasNext()) {
                RelationMember member = (RelationMember)i.next();
                EntityType memberType = member.getMemberType();
                long memberId = member.getMemberId();
                switch (memberType) {
                    case Node: {
                        if (this.availableNodes.get(memberId)) break;
                        i.remove();
                        break;
                    }
                    case Way: {
                        if (this.availableWays.get(memberId)) break;
                        i.remove();
                        break;
                    }
                    case Relation: {
                        if (this.availableRelations.get(memberId)) break;
                        i.remove();
                        break;
                    }
                }
            }
            if (filteredRelation.getMembers().size() > 0) {
                this.sink.process((EntityContainer)filteredRelationContainer);
            }
        } else {
            this.sink.process((EntityContainer)relationContainer);
        }
    }

    private boolean selectParentRelationsPass() {
        try (ReleasableIterator i = this.allRelations.iterate();){
            int selectionCount = 0;
            while (i.hasNext()) {
                Relation relation = ((RelationContainer)i.next()).getEntity();
                long relationId = relation.getId();
                if (this.availableRelations.get(relationId)) continue;
                for (RelationMember member : relation.getMembers()) {
                    if (!member.getMemberType().equals((Object)EntityType.Relation) || !this.availableRelations.get(member.getMemberId())) continue;
                    this.availableRelations.set(relationId);
                    ++selectionCount;
                }
            }
            boolean bl = selectionCount > 0;
            return bl;
        }
    }

    private void selectParentRelations() {
        boolean selectionsMade;
        while (selectionsMade = this.selectParentRelationsPass()) {
        }
    }

    private boolean selectChildRelationsPass() {
        try (ReleasableIterator i = this.allRelations.iterate();){
            int selectionCount = 0;
            while (i.hasNext()) {
                Relation relation = ((RelationContainer)i.next()).getEntity();
                long relationId = relation.getId();
                if (!this.availableRelations.get(relationId)) continue;
                for (RelationMember member : relation.getMembers()) {
                    long memberId;
                    if (!member.getMemberType().equals((Object)EntityType.Relation) || this.availableRelations.get(memberId = member.getMemberId())) continue;
                    this.availableRelations.set(memberId);
                    ++selectionCount;
                }
            }
            boolean bl = selectionCount > 0;
            return bl;
        }
    }

    private void selectChildNonRelationsPass() {
        try (ReleasableIterator i = this.allRelations.iterate();){
            while (i.hasNext()) {
                Relation relation = ((RelationContainer)i.next()).getEntity();
                long relationId = relation.getId();
                if (!this.availableRelations.get(relationId)) continue;
                for (RelationMember member : relation.getMembers()) {
                    switch (member.getMemberType()) {
                        case Node: {
                            this.availableNodes.set(member.getMemberId());
                            break;
                        }
                        case Way: {
                            this.availableWays.set(member.getMemberId());
                            break;
                        }
                    }
                }
            }
        }
    }

    private void selectWayNodes() {
        try (ReleasableIterator i = this.allWays.iterate();){
            while (i.hasNext()) {
                Way way = ((WayContainer)i.next()).getEntity();
                long wayId = way.getId();
                if (!this.availableWays.get(wayId)) continue;
                for (WayNode wayNode : way.getWayNodes()) {
                    this.availableNodes.set(wayNode.getNodeId());
                }
            }
        }
    }

    private void buildCompleteRelations() {
        boolean selectionsMade;
        while (selectionsMade = this.selectChildRelationsPass()) {
        }
        this.selectChildNonRelationsPass();
        this.selectWayNodes();
    }

    private void pumpNodesToSink() {
        try (ReleasableIterator i = this.allNodes.iterate();){
            while (i.hasNext()) {
                NodeContainer nodeContainer = (NodeContainer)i.next();
                if (!this.availableNodes.get(nodeContainer.getEntity().getId())) continue;
                this.emitNode(nodeContainer);
            }
        }
    }

    private void pumpWaysToSink() {
        try (ReleasableIterator i = this.allWays.iterate();){
            while (i.hasNext()) {
                WayContainer wayContainer = (WayContainer)i.next();
                if (!this.availableWays.get(wayContainer.getEntity().getId())) continue;
                this.emitWay(wayContainer);
            }
        }
    }

    private void pumpRelationsToSink() {
        try (ReleasableIterator i = this.allRelations.iterate();){
            while (i.hasNext()) {
                RelationContainer relationContainer = (RelationContainer)i.next();
                if (!this.availableRelations.get(relationContainer.getEntity().getId())) continue;
                this.emitRelation(relationContainer);
            }
        }
    }

    public void complete() {
        if (this.storeEntities) {
            this.selectParentRelations();
            this.availableNodes.setAll(this.requiredNodes);
            this.availableWays.setAll(this.requiredWays);
            this.availableRelations.setAll(this.requiredRelations);
            this.requiredNodes = null;
            this.requiredWays = null;
            this.requiredRelations = null;
            if (this.completeRelations) {
                this.buildCompleteRelations();
            }
            this.pumpNodesToSink();
            this.pumpWaysToSink();
            this.pumpRelationsToSink();
        } else if (this.cascadingRelations) {
            this.selectParentRelations();
            this.availableRelations.setAll(this.requiredRelations);
            this.pumpRelationsToSink();
        }
        this.sink.complete();
    }

    public void close() {
        if (this.allNodes != null) {
            this.allNodes.close();
        }
        if (this.allWays != null) {
            this.allWays.close();
        }
        if (this.allRelations != null) {
            this.allRelations.close();
        }
        this.sink.close();
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

