import { EksCluster } from '@cdktf/provider-aws';
import { Construct } from 'constructs';
import { NodeGroup, NodeGroupOptions, CapacityType, ScalingConfig } from '.';
/**
 * Properties for the Cluster.
 *
 * @stability stable
 */
export interface ClusterProps {
    /**
     * The AWS region to deploy.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * list of public subnetIds for an existing VPC.
     *
     * @stability stable
     */
    readonly publicSubnets?: string[];
    /**
     * list of private subnetIds for an existing VPC.
     *
     * @stability stable
     */
    readonly privateSubnets?: string[];
    /**
     * The Amazon EKS cluster name.
     *
     * @stability stable
     */
    readonly clusterName?: string;
    /**
     * Kubernetes cluster version.
     *
     * @stability stable
     */
    readonly version: KubernetesVersion;
    /**
     * The scaling config of the default nodegroup.
     *
     * @stability stable
     */
    readonly scalingConfig?: ScalingConfig;
    /**
     * capacity type of the nodegroup.
     *
     * @default CapacityType.ON_DEMAND
     * @stability stable
     */
    readonly capacityType?: CapacityType;
    /**
     * instance types of the default nodegroup.
     *
     * @default ['t3.large']
     * @stability stable
     */
    readonly instanceTypes?: string[];
}
/**
 * Kubernetes cluster version.
 *
 * @stability stable
 */
export declare class KubernetesVersion {
    readonly version: string;
    /**
     * Kubernetes version 1.14.
     *
     * @stability stable
     */
    static readonly V1_14: KubernetesVersion;
    /**
     * Kubernetes version 1.15.
     *
     * @stability stable
     */
    static readonly V1_15: KubernetesVersion;
    /**
     * Kubernetes version 1.16.
     *
     * @stability stable
     */
    static readonly V1_16: KubernetesVersion;
    /**
     * Kubernetes version 1.17.
     *
     * @stability stable
     */
    static readonly V1_17: KubernetesVersion;
    /**
     * Kubernetes version 1.18.
     *
     * @stability stable
     */
    static readonly V1_18: KubernetesVersion;
    /**
     * Kubernetes version 1.19.
     *
     * @stability stable
     */
    static readonly V1_19: KubernetesVersion;
    /**
     * Kubernetes version 1.20.
     *
     * @stability stable
     */
    static readonly V1_20: KubernetesVersion;
    /**
     * Kubernetes version 1.21.
     *
     * @stability stable
     */
    static readonly V1_21: KubernetesVersion;
    /**
     * Custom cluster version.
     *
     * @param version custom version number.
     * @stability stable
     */
    static of(version: string): KubernetesVersion;
    /**
     *
     * @param version cluster version number
     */
    private constructor();
}
/**
 * The Amazon EKS Cluster with a default nodegroup.
 *
 * @stability stable
 */
export declare class Cluster extends Construct {
    /**
     * @stability stable
     */
    readonly props: ClusterProps;
    /**
     * @stability stable
     */
    readonly publicSubnets: string[];
    /**
     * @stability stable
     */
    readonly privateSubnets: string[];
    /**
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * @stability stable
     */
    readonly cluster: EksCluster;
    /**
     * @stability stable
     */
    readonly vpc?: any;
    /**
     * @stability stable
     */
    readonly vpcId?: string;
    /**
     * @stability stable
     */
    readonly defaultNodeGroup?: NodeGroup;
    private readonly region;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ClusterProps);
    private _createVpc;
    private _createClusterRole;
    private getAllSubnetsFromVpcId;
    /**
     * @stability stable
     */
    addNodeGroup(id: string, options: NodeGroupOptions): void;
}
