"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryParameterMatch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Used to generate query parameter matching methods.
 */
class QueryParameterMatch {
    /**
     * The value of the query parameter with the given name in the request must match the
     * specified value exactly.
     *
     * @param queryParameterName the name of the query parameter to match against
     * @param queryParameterValue The exact value to test against
     */
    static valueIs(queryParameterName, queryParameterValue) {
        return new QueryParameterMatchImpl(queryParameterName, { exact: queryParameterValue });
    }
}
exports.QueryParameterMatch = QueryParameterMatch;
_a = JSII_RTTI_SYMBOL_1;
QueryParameterMatch[_a] = { fqn: "@aws-cdk/aws-appmesh.QueryParameterMatch", version: "1.175.0" };
class QueryParameterMatchImpl extends QueryParameterMatch {
    constructor(queryParameterName, matchProperty) {
        super();
        this.queryParameterName = queryParameterName;
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            queryParameterMatch: {
                match: this.matchProperty,
                name: this.queryParameterName,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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