"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const assignment_1 = require("./assignment");
const permissionset_common_1 = require("./private/permissionset-common");
/**
 * The base permission set class
 */
class PermissionSetBase extends aws_cdk_lib_1.Resource {
    grant(principal, targetId) {
        return new assignment_1.Assignment(this, 'Assignment', {
            permissionSet: this,
            principal: principal,
            targetId,
        });
    }
}
;
class PermissionSet extends PermissionSetBase {
    constructor(scope, id, props) {
        super(scope, id);
        let managedPolicies = [];
        if (props.awsManagedPolicies) {
            managedPolicies = props.awsManagedPolicies.map(policy => policy.managedPolicyArn);
        }
        if (!props.ssoInstanceArn.match(/arn:(aws|aws-us-gov|aws-cn|aws-iso|aws-iso-b):sso:::instance\/(sso)?ins-[a-zA-Z0-9-.]{16}/)) {
            throw new Error(`Invalid SSO instance ARN: ${props.ssoInstanceArn}`);
        }
        if (!props.name.match(/[\w+=,.@-]+/)) {
            throw new Error(`Invalid permission set name. Name may only contain alphanumeric characters and any of: +=,.@-. You gave: ${props.name}`);
        }
        if (props.relayStateType && !props.relayStateType.match(/[a-zA-Z0-9&$@#\\\/%?=~\-_'"|!:,.;*+\[\]\ \(\)\{\}]+/)) {
            throw new Error(`Invalid relay state type: ${props.relayStateType}`);
        }
        this.cfnPermissionSet = new aws_cdk_lib_1.aws_sso.CfnPermissionSet(this, 'permissionSet', {
            instanceArn: props.ssoInstanceArn,
            name: props.name,
            customerManagedPolicyReferences: props.customerManagedPolicyReferences,
            description: props.description,
            inlinePolicy: props.inlinePolicy,
            managedPolicies,
            permissionsBoundary: props.permissionsBoundary,
            relayStateType: props.relayStateType,
            sessionDuration: props.sessionDuration ? props.sessionDuration.toIsoString() : undefined,
        });
        this.ssoInstanceArn = props.ssoInstanceArn;
        this.permissionSetArn = this.cfnPermissionSet.attrPermissionSetArn;
    }
    /**
     * Reference an existing permission set by ARN
     */
    static fromPermissionSetArn(scope, id, permissionSetArn) {
        class Import extends PermissionSetBase {
            constructor() {
                super(...arguments);
                this.permissionSetArn = permissionSetArn;
                this.ssoInstanceArn = permissionset_common_1.permissionSetParseArn(permissionSetArn).partition;
            }
        }
        ;
        const permissionSet = new Import(scope, id);
        return permissionSet;
    }
}
exports.PermissionSet = PermissionSet;
_a = JSII_RTTI_SYMBOL_1;
PermissionSet[_a] = { fqn: "@renovosolutions/cdk-library-aws-sso.PermissionSet", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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